/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.Configuration;
import alluxio.master.Master;
import alluxio.master.MasterContext;
import alluxio.master.journal.Journal;
import alluxio.master.journal.JournalTailer;
import alluxio.util.CommonUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class JournalTailerThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final Master mMaster;
    private final Journal mJournal;
    private final int mShutdownQuietWaitTimeMs;
    private final int mJournalTailerSleepTimeMs;
    private volatile boolean mInitiateShutdown = false;
    private JournalTailer mJournalTailer = null;
    private boolean mStopped = false;

    public JournalTailerThread(Master master, Journal journal) {
        this.mMaster = (Master)Preconditions.checkNotNull((Object)master);
        this.mJournal = (Journal)Preconditions.checkNotNull((Object)journal);
        Configuration conf = MasterContext.getConf();
        this.mShutdownQuietWaitTimeMs = conf.getInt("alluxio.master.journal.tailer.shutdown.quiet.wait.time.ms");
        this.mJournalTailerSleepTimeMs = conf.getInt("alluxio.master.journal.tailer.sleep.time.ms");
    }

    public void shutdown() {
        LOG.info("{}: Journal tailer shutdown has been initiated.", (Object)this.mMaster.getName());
        this.mInitiateShutdown = true;
    }

    public void shutdownAndJoin() {
        this.shutdown();
        try {
            this.join();
        }
        catch (InterruptedException e) {
            LOG.warn("{}: stopping the journal tailer caused an exception", (Object)this.mMaster.getName(), (Object)e);
        }
    }

    public JournalTailer getLatestJournalTailer() {
        if (this.mStopped) {
            return this.mJournalTailer;
        }
        return null;
    }

    @Override
    public void run() {
        LOG.info("{}: Journal tailer started.", (Object)this.mMaster.getName());
        while (!this.mInitiateShutdown) {
            try {
                long waitForShutdownStart = -1L;
                LOG.info("{}: Waiting to load the checkpoint file.", (Object)this.mMaster.getName());
                this.mJournalTailer = new JournalTailer(this.mMaster, this.mJournal);
                while (!this.mJournalTailer.checkpointExists()) {
                    CommonUtils.sleepMs((Logger)LOG, (long)this.mJournalTailerSleepTimeMs);
                    if (!this.mInitiateShutdown) continue;
                    LOG.info("Journal tailer has been shutdown while waiting to load the checkpoint file.");
                    this.mStopped = true;
                    return;
                }
                LOG.info("{}: Start loading the checkpoint file.", (Object)this.mMaster.getName());
                this.mJournalTailer.processJournalCheckpoint(true);
                LOG.info("{}: Checkpoint file has been loaded.", (Object)this.mMaster.getName());
                while (this.mJournalTailer.isValid()) {
                    if (this.mJournalTailer.processNextJournalLogFiles() > 0) {
                        waitForShutdownStart = -1L;
                        continue;
                    }
                    if (this.mInitiateShutdown) {
                        if (waitForShutdownStart == -1L) {
                            waitForShutdownStart = CommonUtils.getCurrentMs();
                        } else if (CommonUtils.getCurrentMs() - waitForShutdownStart > (long)this.mShutdownQuietWaitTimeMs) {
                            LOG.info("{}: Journal tailer has been shutdown. No new logs for the quiet period.", (Object)this.mMaster.getName());
                            this.mStopped = true;
                            return;
                        }
                    }
                    LOG.debug("{}: The next complete log file does not exist yet. Sleeping and checking again.", (Object)this.mMaster.getName());
                    CommonUtils.sleepMs((Logger)LOG, (long)this.mJournalTailerSleepTimeMs);
                }
                LOG.info("{}: The checkpoint is out of date. Will reload the checkpoint file.", (Object)this.mMaster.getName());
                CommonUtils.sleepMs((Logger)LOG, (long)this.mJournalTailerSleepTimeMs);
            }
            catch (IOException e) {
                LOG.error("Error in journal tailer thread", (Throwable)e);
            }
        }
        LOG.info("{}: Journal tailer has been shutdown.", (Object)this.mMaster.getName());
        this.mStopped = true;
    }
}

