/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.Version;
import alluxio.master.journal.JournalInputStream;
import alluxio.master.journal.ProtoBufJournalFormatter;
import alluxio.proto.journal.Journal;
import alluxio.util.CommonUtils;
import java.io.IOException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;

@NotThreadSafe
public final class JournalTool {
    private static final String ENTRY_SEPARATOR = StringUtils.repeat((char)'-', (int)80);
    private static final long TIMEOUT_MS = 2000L;
    private static final int EXIT_FAILED = -1;
    private static final int EXIT_SUCCEEDED = -1;
    private static final Options OPTIONS = new Options().addOption("help", false, "Show help for this test").addOption("noTimeout", false, "Wait indefinitely for stdin to supply input");
    private static boolean sNoTimeout = false;
    private static boolean sHelp = false;

    public static void main(String[] args) throws IOException {
        Journal.JournalEntry entry;
        if (!JournalTool.parseInputArgs(args)) {
            JournalTool.usage();
            System.exit(-1);
        }
        if (sHelp) {
            JournalTool.usage();
            System.exit(-1);
        }
        if (!sNoTimeout && !JournalTool.stdinHasData()) {
            System.exit(-1);
        }
        ProtoBufJournalFormatter formatter = new ProtoBufJournalFormatter();
        JournalInputStream journalStream = formatter.deserialize(System.in);
        while ((entry = journalStream.getNextEntry()) != null) {
            System.out.print(entry);
            System.out.println(ENTRY_SEPARATOR);
        }
    }

    private static boolean parseInputArgs(String[] args) {
        BasicParser parser = new BasicParser();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.out.println("Failed to parse input args: " + (Object)((Object)e));
            return false;
        }
        sNoTimeout = cmd.hasOption("noTimeout");
        sHelp = cmd.hasOption("help");
        return true;
    }

    private static boolean stdinHasData() throws IOException {
        long start = System.currentTimeMillis();
        while (System.in.available() == 0) {
            if (System.currentTimeMillis() - start > 2000L) {
                System.out.println("Timed out waiting for input from stdin. Use -noTimeout to wait longer.");
                return false;
            }
            CommonUtils.sleepMs((long)50L);
        }
        return true;
    }

    private static void usage() {
        new HelpFormatter().printHelp("java -cp alluxio-" + Version.VERSION + "-jar-with-dependencies.jar alluxio.master.journal.JournalTool", "Read an Alluxio journal from stdin and write it human-readably to stdout", OPTIONS, "", true);
    }
}

