/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.journal;

import alluxio.master.journal.JournalFormatter;
import alluxio.master.journal.JournalInputStream;
import alluxio.proto.journal.Journal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ProtoBufJournalFormatter
implements JournalFormatter {
    @Override
    public void serialize(Journal.JournalEntry entry, OutputStream outputStream) throws IOException {
        entry.writeDelimitedTo(outputStream);
    }

    @Override
    public JournalInputStream deserialize(final InputStream inputStream) throws IOException {
        return new JournalInputStream(){
            private long mLatestSequenceNumber;

            @Override
            public Journal.JournalEntry getNextEntry() throws IOException {
                Journal.JournalEntry entry = Journal.JournalEntry.parseDelimitedFrom(inputStream);
                if (entry != null) {
                    this.mLatestSequenceNumber = entry.getSequenceNumber();
                }
                return entry;
            }

            @Override
            public void close() throws IOException {
                inputStream.close();
            }

            @Override
            public long getLatestSequenceNumber() {
                return this.mLatestSequenceNumber;
            }
        };
    }
}

