/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.lineage;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.exception.AccessControlException;
import alluxio.exception.BlockInfoException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.exception.LineageDeletionException;
import alluxio.exception.LineageDoesNotExistException;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.heartbeat.HeartbeatThread;
import alluxio.job.CommandLineJob;
import alluxio.job.Job;
import alluxio.master.AbstractMaster;
import alluxio.master.MasterContext;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.file.options.CreateFileOptions;
import alluxio.master.journal.Journal;
import alluxio.master.journal.JournalOutputStream;
import alluxio.master.journal.JournalProtoUtils;
import alluxio.master.lineage.LineageMasterClientServiceHandler;
import alluxio.master.lineage.checkpoint.CheckpointPlan;
import alluxio.master.lineage.checkpoint.CheckpointSchedulingExcecutor;
import alluxio.master.lineage.meta.Lineage;
import alluxio.master.lineage.meta.LineageIdGenerator;
import alluxio.master.lineage.meta.LineageStore;
import alluxio.master.lineage.meta.LineageStoreView;
import alluxio.master.lineage.recompute.RecomputeExecutor;
import alluxio.master.lineage.recompute.RecomputePlanner;
import alluxio.proto.journal.Journal;
import alluxio.proto.journal.Lineage;
import alluxio.thrift.LineageMasterClientService;
import alluxio.util.io.PathUtils;
import alluxio.wire.FileInfo;
import alluxio.wire.LineageInfo;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.protobuf.Message;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.TProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class LineageMaster
extends AbstractMaster {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final Configuration mConfiguration = MasterContext.getConf();
    private final LineageStore mLineageStore;
    private final FileSystemMaster mFileSystemMaster;
    private final LineageIdGenerator mLineageIdGenerator;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private Future<?> mCheckpointExecutionService;
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"})
    private Future<?> mRecomputeExecutionService;

    public static String getJournalDirectory(String baseDirectory) {
        return PathUtils.concatPath((Object)baseDirectory, (Object[])new Object[]{"LineageMaster"});
    }

    public LineageMaster(FileSystemMaster fileSystemMaster, Journal journal) {
        super(journal, 2);
        this.mFileSystemMaster = (FileSystemMaster)Preconditions.checkNotNull((Object)fileSystemMaster);
        this.mLineageIdGenerator = new LineageIdGenerator();
        this.mLineageStore = new LineageStore(this.mLineageIdGenerator);
    }

    @Override
    public Map<String, TProcessor> getServices() {
        HashMap<String, TProcessor> services = new HashMap<String, TProcessor>();
        services.put("LineageMasterClient", (TProcessor)new LineageMasterClientService.Processor((LineageMasterClientService.Iface)new LineageMasterClientServiceHandler(this)));
        return services;
    }

    @Override
    public String getName() {
        return "LineageMaster";
    }

    @Override
    public void processJournalEntry(Journal.JournalEntry entry) throws IOException {
        Message innerEntry = JournalProtoUtils.unwrap(entry);
        if (innerEntry instanceof Lineage.LineageEntry) {
            this.mLineageStore.addLineageFromJournal((Lineage.LineageEntry)innerEntry);
        } else if (innerEntry instanceof Lineage.LineageIdGeneratorEntry) {
            this.mLineageIdGenerator.initFromJournalEntry((Lineage.LineageIdGeneratorEntry)innerEntry);
        } else if (innerEntry instanceof Lineage.DeleteLineageEntry) {
            this.deleteLineageFromEntry((Lineage.DeleteLineageEntry)innerEntry);
        } else {
            throw new IOException(ExceptionMessage.UNEXPECTED_JOURNAL_ENTRY.getMessage(new Object[]{innerEntry}));
        }
    }

    @Override
    public void start(boolean isLeader) throws IOException {
        super.start(isLeader);
        if (isLeader) {
            this.mCheckpointExecutionService = this.getExecutorService().submit((Runnable)new HeartbeatThread("Master Checkpoint Scheduling", (HeartbeatExecutor)new CheckpointSchedulingExcecutor(this, this.mFileSystemMaster), (long)this.mConfiguration.getInt("alluxio.master.lineage.checkpoint.interval.ms")));
            this.mRecomputeExecutionService = this.getExecutorService().submit((Runnable)new HeartbeatThread("Master File Recomputation", (HeartbeatExecutor)new RecomputeExecutor(new RecomputePlanner(this.mLineageStore, this.mFileSystemMaster), this.mFileSystemMaster), (long)this.mConfiguration.getInt("alluxio.master.lineage.recompute.interval.ms")));
        }
    }

    @Override
    public synchronized void streamToJournalCheckpoint(JournalOutputStream outputStream) throws IOException {
        this.mLineageStore.streamToJournalCheckpoint(outputStream);
        outputStream.writeEntry(this.mLineageIdGenerator.toJournalEntry());
    }

    public LineageStoreView getLineageStoreView() {
        return new LineageStoreView(this.mLineageStore);
    }

    public synchronized long createLineage(List<AlluxioURI> inputFiles, List<AlluxioURI> outputFiles, Job job) throws InvalidPathException, FileAlreadyExistsException, BlockInfoException, IOException, AccessControlException {
        ArrayList inputAlluxioFiles = Lists.newArrayList();
        for (AlluxioURI inputFile : inputFiles) {
            long fileId = this.mFileSystemMaster.getFileId(inputFile);
            if (fileId == -1L) {
                throw new InvalidPathException(ExceptionMessage.LINEAGE_INPUT_FILE_NOT_EXIST.getMessage(new Object[]{inputFile}));
            }
            inputAlluxioFiles.add(fileId);
        }
        ArrayList outputAlluxioFiles = Lists.newArrayList();
        for (AlluxioURI outputFile : outputFiles) {
            CreateFileOptions options = new CreateFileOptions.Builder(MasterContext.getConf()).setRecursive(true).setBlockSizeBytes(1024L).build();
            long fileId = this.mFileSystemMaster.create(outputFile, options);
            outputAlluxioFiles.add(fileId);
        }
        LOG.info("Create lineage of input:{}, output:{}, job:{}", new Object[]{inputAlluxioFiles, outputAlluxioFiles, job});
        long lineageId = this.mLineageStore.createLineage(inputAlluxioFiles, outputAlluxioFiles, job);
        this.writeJournalEntry(this.mLineageIdGenerator.toJournalEntry());
        this.writeJournalEntry(this.mLineageStore.getLineage(lineageId).toJournalEntry());
        this.flushJournal();
        return lineageId;
    }

    public synchronized boolean deleteLineage(long lineageId, boolean cascade) throws LineageDoesNotExistException, LineageDeletionException {
        this.deleteLineageInternal(lineageId, cascade);
        Lineage.DeleteLineageEntry deleteLineage = Lineage.DeleteLineageEntry.newBuilder().setLineageId(lineageId).setCascade(cascade).build();
        this.writeJournalEntry(Journal.JournalEntry.newBuilder().setDeleteLineage(deleteLineage).build());
        this.flushJournal();
        return true;
    }

    private boolean deleteLineageInternal(long lineageId, boolean cascade) throws LineageDoesNotExistException, LineageDeletionException {
        Lineage lineage = this.mLineageStore.getLineage(lineageId);
        LineageDoesNotExistException.check((lineage != null ? 1 : 0) != 0, (ExceptionMessage)ExceptionMessage.LINEAGE_DOES_NOT_EXIST, (Object[])new Object[]{lineageId});
        if (!cascade && !this.mLineageStore.getChildren(lineage).isEmpty()) {
            throw new LineageDeletionException(ExceptionMessage.DELETE_LINEAGE_WITH_CHILDREN.getMessage(new Object[]{lineageId}));
        }
        LOG.info("Delete lineage {}", (Object)lineageId);
        this.mLineageStore.deleteLineage(lineageId);
        return true;
    }

    private void deleteLineageFromEntry(Lineage.DeleteLineageEntry entry) {
        try {
            this.deleteLineageInternal(entry.getLineageId(), entry.getCascade());
        }
        catch (LineageDoesNotExistException e) {
            LOG.error("Failed to delete lineage {}", (Object)entry.getLineageId(), (Object)e);
        }
        catch (LineageDeletionException e) {
            LOG.error("Failed to delete lineage {}", (Object)entry.getLineageId(), (Object)e);
        }
    }

    public synchronized long reinitializeFile(String path, long blockSizeBytes, long ttl) throws InvalidPathException, LineageDoesNotExistException, AccessControlException {
        FileInfo fileInfo;
        long fileId = this.mFileSystemMaster.getFileId(new AlluxioURI(path));
        try {
            fileInfo = this.mFileSystemMaster.getFileInfo(fileId);
        }
        catch (FileDoesNotExistException e) {
            throw new LineageDoesNotExistException(ExceptionMessage.MISSING_REINITIALIZE_FILE.getMessage(new Object[]{path}));
        }
        if (!fileInfo.isCompleted() || this.mFileSystemMaster.getLostFiles().contains(fileId)) {
            LOG.info("Recreate the file {} with block size of {} bytes", (Object)path, (Object)blockSizeBytes);
            return this.mFileSystemMaster.reinitializeFile(new AlluxioURI(path), blockSizeBytes, ttl);
        }
        return -1L;
    }

    public synchronized List<LineageInfo> getLineageInfoList() throws LineageDoesNotExistException, FileDoesNotExistException {
        ArrayList lineages = Lists.newArrayList();
        for (Lineage lineage : this.mLineageStore.getAllInTopologicalOrder()) {
            LineageInfo info = new LineageInfo();
            ArrayList parents = Lists.newArrayList();
            for (Lineage parent : this.mLineageStore.getParents(lineage)) {
                parents.add(parent.getId());
            }
            info.setParents((List)parents);
            ArrayList children = Lists.newArrayList();
            for (Lineage child : this.mLineageStore.getChildren(lineage)) {
                children.add(child.getId());
            }
            info.setChildren((List)children);
            info.setId(lineage.getId());
            ArrayList inputFiles = Lists.newArrayList();
            for (long inputFileId : lineage.getInputFiles()) {
                inputFiles.add(this.mFileSystemMaster.getPath(inputFileId).toString());
            }
            info.setInputFiles((List)inputFiles);
            ArrayList outputFiles = Lists.newArrayList();
            for (long outputFileId : lineage.getOutputFiles()) {
                outputFiles.add(this.mFileSystemMaster.getPath(outputFileId).toString());
            }
            info.setOutputFiles((List)outputFiles);
            info.setCreationTimeMs(lineage.getCreationTime());
            info.setJob(((CommandLineJob)lineage.getJob()).generateCommandLineJobInfo());
            lineages.add(info);
        }
        return lineages;
    }

    public synchronized void scheduleForCheckpoint(CheckpointPlan plan) throws FileDoesNotExistException {
        for (long lineageId : plan.getLineagesToCheckpoint()) {
            Lineage lineage = this.mLineageStore.getLineage(lineageId);
            for (long file : lineage.getOutputFiles()) {
                try {
                    this.mFileSystemMaster.scheduleAsyncPersistence(this.mFileSystemMaster.getPath(file));
                }
                catch (InvalidPathException e) {
                    LOG.error("The file {} to persist had an invalid path associated with it.", (Object)file, (Object)e);
                    throw new FileDoesNotExistException(e.getMessage());
                }
            }
        }
    }

    public synchronized void reportLostFile(String path) throws FileDoesNotExistException, AccessControlException {
        long fileId = this.mFileSystemMaster.getFileId(new AlluxioURI(path));
        this.mFileSystemMaster.reportLostFile(fileId);
    }
}

