/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.lineage;

import alluxio.AlluxioURI;
import alluxio.exception.AlluxioException;
import alluxio.job.CommandLineJob;
import alluxio.job.Job;
import alluxio.job.JobConf;
import alluxio.master.lineage.LineageMaster;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.CommandLineJobInfo;
import alluxio.thrift.LineageInfo;
import alluxio.thrift.LineageMasterClientService;
import alluxio.thrift.ThriftIOException;
import alluxio.wire.ThriftUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LineageMasterClientServiceHandler
implements LineageMasterClientService.Iface {
    private final LineageMaster mLineageMaster;

    public LineageMasterClientServiceHandler(LineageMaster lineageMaster) {
        Preconditions.checkNotNull((Object)lineageMaster);
        this.mLineageMaster = lineageMaster;
    }

    public long getServiceVersion() {
        return 1L;
    }

    public long createLineage(List<String> inputFiles, List<String> outputFiles, CommandLineJobInfo jobInfo) throws AlluxioTException, ThriftIOException {
        ArrayList inputFilesUri = Lists.newArrayList();
        for (String inputFile : inputFiles) {
            inputFilesUri.add(new AlluxioURI(inputFile));
        }
        ArrayList outputFilesUri = Lists.newArrayList();
        for (String outputFile : outputFiles) {
            outputFilesUri.add(new AlluxioURI(outputFile));
        }
        CommandLineJob job = new CommandLineJob(jobInfo.getCommand(), new JobConf(jobInfo.getConf().getOutputFile()));
        try {
            return this.mLineageMaster.createLineage(inputFilesUri, outputFilesUri, (Job)job);
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
    }

    public boolean deleteLineage(long lineageId, boolean cascade) throws AlluxioTException {
        try {
            return this.mLineageMaster.deleteLineage(lineageId, cascade);
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public long reinitializeFile(String path, long blockSizeBytes, long ttl) throws AlluxioTException {
        try {
            return this.mLineageMaster.reinitializeFile(path, blockSizeBytes, ttl);
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public void reportLostFile(String path) throws AlluxioTException, ThriftIOException {
        try {
            this.mLineageMaster.reportLostFile(path);
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public List<LineageInfo> getLineageInfoList() throws AlluxioTException {
        try {
            ArrayList<LineageInfo> result = new ArrayList<LineageInfo>();
            for (alluxio.wire.LineageInfo lineageInfo : this.mLineageMaster.getLineageInfoList()) {
                result.add(ThriftUtils.toThrift((alluxio.wire.LineageInfo)lineageInfo));
            }
            return result;
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }
}

