/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.lineage.checkpoint;

import alluxio.exception.FileDoesNotExistException;
import alluxio.master.file.meta.FileSystemMasterView;
import alluxio.master.lineage.checkpoint.CheckpointPlan;
import alluxio.master.lineage.checkpoint.CheckpointPlanner;
import alluxio.master.lineage.meta.Lineage;
import alluxio.master.lineage.meta.LineageStateUtils;
import alluxio.master.lineage.meta.LineageStoreView;
import com.google.common.collect.Lists;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class CheckpointLatestPlanner
implements CheckpointPlanner {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");

    public CheckpointLatestPlanner(LineageStoreView lineageStoreView, FileSystemMasterView fileSystemMasterView) {
    }

    @Override
    public CheckpointPlan generatePlan(LineageStoreView store, FileSystemMasterView fileSystemMasterView) {
        Lineage toCheckpoint = null;
        long latestCreated = 0L;
        for (Lineage lineage : store.getAllLineagesInTopologicalOrder()) {
            block4: {
                try {
                    if (!LineageStateUtils.isCompleted(lineage, fileSystemMasterView) || LineageStateUtils.isPersisted(lineage, fileSystemMasterView) || LineageStateUtils.needRecompute(lineage, fileSystemMasterView)) continue;
                    if (LineageStateUtils.isInCheckpointing(lineage, fileSystemMasterView)) {
                    }
                    break block4;
                }
                catch (FileDoesNotExistException e) {
                    LOG.error("The lineage file does not exist", (Throwable)e);
                }
                continue;
            }
            if (lineage.getCreationTime() <= latestCreated) continue;
            latestCreated = lineage.getCreationTime();
            toCheckpoint = lineage;
        }
        return toCheckpoint == null ? new CheckpointPlan(Lists.newArrayList()) : new CheckpointPlan(Lists.newArrayList((Object[])new Long[]{toCheckpoint.getId()}));
    }
}

