/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.lineage.checkpoint;

import alluxio.Configuration;
import alluxio.exception.FileDoesNotExistException;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.master.MasterContext;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.lineage.LineageMaster;
import alluxio.master.lineage.checkpoint.CheckpointPlan;
import alluxio.master.lineage.checkpoint.CheckpointPlanner;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class CheckpointSchedulingExcecutor
implements HeartbeatExecutor {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final Configuration mConfiguration;
    private final LineageMaster mLineageMaster;
    private final FileSystemMaster mFileSystemMaster;
    private final CheckpointPlanner mPlanner;

    public CheckpointSchedulingExcecutor(LineageMaster lineageMaster, FileSystemMaster fileSystemMaster) {
        this.mLineageMaster = (LineageMaster)Preconditions.checkNotNull((Object)lineageMaster);
        this.mFileSystemMaster = (FileSystemMaster)Preconditions.checkNotNull((Object)fileSystemMaster);
        this.mConfiguration = MasterContext.getConf();
        this.mPlanner = CheckpointPlanner.Factory.create(this.mConfiguration, this.mLineageMaster.getLineageStoreView(), this.mFileSystemMaster.getFileSystemMasterView());
    }

    public void heartbeat() {
        CheckpointPlan plan = this.mPlanner.generatePlan(this.mLineageMaster.getLineageStoreView(), this.mFileSystemMaster.getFileSystemMasterView());
        if (!plan.isEmpty()) {
            LOG.info("Checkpoint scheduler created the plan: {}", (Object)plan);
        }
        try {
            this.mLineageMaster.scheduleForCheckpoint(plan);
        }
        catch (FileDoesNotExistException e) {
            LOG.error("Checkpoint scheduling failed: {}", (Throwable)e);
        }
    }

    public void close() {
    }
}

