/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.lineage.meta;

import alluxio.job.CommandLineJob;
import alluxio.job.Job;
import alluxio.job.JobConf;
import alluxio.master.journal.JournalEntryRepresentable;
import alluxio.proto.journal.Journal;
import alluxio.proto.journal.Lineage;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.lang.builder.ToStringBuilder;

@NotThreadSafe
public final class Lineage
implements JournalEntryRepresentable {
    private final long mId;
    private final List<Long> mInputFiles;
    private final List<Long> mOutputFiles;
    private final Job mJob;
    private final long mCreationTimeMs;

    public Lineage(long id, List<Long> inputFiles, List<Long> outputFiles, Job job) {
        this(id, inputFiles, outputFiles, job, System.currentTimeMillis());
    }

    public Lineage(long id, List<Long> inputFiles, List<Long> outputFiles, Job job, long creationTimeMs) {
        this.mInputFiles = (List)Preconditions.checkNotNull(inputFiles);
        this.mOutputFiles = (List)Preconditions.checkNotNull(outputFiles);
        this.mJob = (Job)Preconditions.checkNotNull((Object)job);
        this.mId = id;
        this.mCreationTimeMs = creationTimeMs;
    }

    public synchronized List<Long> getInputFiles() {
        return Collections.unmodifiableList(this.mInputFiles);
    }

    public synchronized List<Long> getOutputFiles() {
        return Collections.unmodifiableList(this.mOutputFiles);
    }

    public Job getJob() {
        return this.mJob;
    }

    public long getId() {
        return this.mId;
    }

    public long getCreationTime() {
        return this.mCreationTimeMs;
    }

    public static Lineage fromJournalEntry(Lineage.LineageEntry entry) {
        ArrayList inputFiles = Lists.newArrayList(entry.getInputFilesList());
        ArrayList outputFiles = Lists.newArrayList();
        CommandLineJob job = new CommandLineJob(entry.getJobCommand(), new JobConf(entry.getJobOutputPath()));
        return new Lineage(entry.getId(), inputFiles, outputFiles, (Job)job, entry.getCreationTimeMs());
    }

    @Override
    public synchronized Journal.JournalEntry toJournalEntry() {
        ArrayList inputFileIds = Lists.newArrayList(this.mInputFiles);
        ArrayList outputFileIds = Lists.newArrayList(this.mOutputFiles);
        Preconditions.checkState((boolean)(this.mJob instanceof CommandLineJob));
        CommandLineJob commandLineJob = (CommandLineJob)this.mJob;
        String jobCommand = commandLineJob.getCommand();
        String jobOutputPath = commandLineJob.getJobConf().getOutputFilePath();
        Lineage.LineageEntry lineage = Lineage.LineageEntry.newBuilder().setId(this.mId).addAllInputFiles(inputFileIds).addAllOutputFileIds(outputFileIds).setJobCommand(jobCommand).setJobOutputPath(jobOutputPath).setCreationTimeMs(this.mCreationTimeMs).build();
        return Journal.JournalEntry.newBuilder().setLineage(lineage).build();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

