/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.lineage.meta;

import alluxio.master.journal.JournalEntryRepresentable;
import alluxio.proto.journal.Journal;
import alluxio.proto.journal.Lineage;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LineageIdGenerator
implements JournalEntryRepresentable {
    private AtomicLong mSequenceNumber = new AtomicLong(0L);

    synchronized long generateId() {
        return this.mSequenceNumber.getAndIncrement();
    }

    public void initFromJournalEntry(Lineage.LineageIdGeneratorEntry entry) {
        this.mSequenceNumber = new AtomicLong(entry.getSequenceNumber());
    }

    @Override
    public Journal.JournalEntry toJournalEntry() {
        Lineage.LineageIdGeneratorEntry lineageIdGenerator = Lineage.LineageIdGeneratorEntry.newBuilder().setSequenceNumber(this.mSequenceNumber.longValue()).build();
        return Journal.JournalEntry.newBuilder().setLineageIdGenerator(lineageIdGenerator).build();
    }
}

