/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.lineage.meta;

import alluxio.exception.FileDoesNotExistException;
import alluxio.master.file.meta.FileSystemMasterView;
import alluxio.master.file.meta.PersistenceState;
import alluxio.master.lineage.meta.Lineage;
import alluxio.wire.FileInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LineageStateUtils {
    private LineageStateUtils() {
    }

    public static boolean isCompleted(Lineage lineage, FileSystemMasterView fileSystemMasterView) throws FileDoesNotExistException {
        for (long outputFile : lineage.getOutputFiles()) {
            FileInfo fileInfo = fileSystemMasterView.getFileInfo(outputFile);
            if (fileInfo.isCompleted()) continue;
            return false;
        }
        return true;
    }

    public static boolean needRecompute(Lineage lineage, FileSystemMasterView fileSystemMasterView) throws FileDoesNotExistException {
        List<Long> lostFiles = fileSystemMasterView.getLostFiles();
        for (long outputFile : lineage.getOutputFiles()) {
            if (!lostFiles.contains(outputFile)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPersisted(Lineage lineage, FileSystemMasterView fileSystemMasterView) throws FileDoesNotExistException {
        for (long outputFile : lineage.getOutputFiles()) {
            if (fileSystemMasterView.getFilePersistenceState(outputFile) == PersistenceState.PERSISTED) continue;
            return false;
        }
        return true;
    }

    public static boolean isInCheckpointing(Lineage lineage, FileSystemMasterView fileSystemMasterView) throws FileDoesNotExistException {
        for (long outputFile : lineage.getOutputFiles()) {
            if (fileSystemMasterView.getFilePersistenceState(outputFile) != PersistenceState.IN_PROGRESS) continue;
            return true;
        }
        return false;
    }

    public static List<Long> getLostFiles(Lineage lineage, FileSystemMasterView fileSystemMasterView) throws FileDoesNotExistException {
        ArrayList result = Lists.newArrayList();
        List<Long> lostFiles = fileSystemMasterView.getLostFiles();
        for (long outputFile : lineage.getOutputFiles()) {
            if (!lostFiles.contains(outputFile)) continue;
            result.add(outputFile);
        }
        return result;
    }
}

