/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.lineage.meta;

import alluxio.collections.DirectedAcyclicGraph;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.LineageDoesNotExistException;
import alluxio.job.Job;
import alluxio.master.journal.JournalCheckpointStreamable;
import alluxio.master.journal.JournalOutputStream;
import alluxio.master.lineage.meta.Lineage;
import alluxio.master.lineage.meta.LineageIdGenerator;
import alluxio.proto.journal.Lineage;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class LineageStore
implements JournalCheckpointStreamable {
    private final LineageIdGenerator mLineageIdGenerator;
    private final DirectedAcyclicGraph<Lineage> mLineageDAG;
    private Map<Long, Lineage> mOutputFileIndex;
    private Map<Long, Lineage> mIdIndex;

    public LineageStore(LineageIdGenerator lineageIdGenerator) {
        this.mLineageIdGenerator = lineageIdGenerator;
        this.mLineageDAG = new DirectedAcyclicGraph();
        this.mOutputFileIndex = Maps.newHashMap();
        this.mIdIndex = Maps.newHashMap();
    }

    public synchronized void addLineageFromJournal(Lineage.LineageEntry entry) {
        Lineage lineage = Lineage.fromJournalEntry(entry);
        this.createLineageInternal(lineage);
    }

    public synchronized long createLineage(List<Long> inputFiles, List<Long> outputFiles, Job job) {
        long lineageId = this.mLineageIdGenerator.generateId();
        Lineage lineage = new Lineage(lineageId, inputFiles, outputFiles, job);
        this.createLineageInternal(lineage);
        return lineageId;
    }

    private void createLineageInternal(Lineage lineage) {
        ArrayList parentLineages = Lists.newArrayList();
        for (long inputFile : lineage.getInputFiles()) {
            if (!this.mOutputFileIndex.containsKey(inputFile)) continue;
            parentLineages.add(this.mOutputFileIndex.get(inputFile));
        }
        this.mLineageDAG.add((Object)lineage, (List)parentLineages);
        for (long outputFile : lineage.getOutputFiles()) {
            this.mOutputFileIndex.put(outputFile, lineage);
        }
        this.mIdIndex.put(lineage.getId(), lineage);
    }

    public synchronized void deleteLineage(long lineageId) throws LineageDoesNotExistException {
        LineageDoesNotExistException.check((boolean)this.mIdIndex.containsKey(lineageId), (ExceptionMessage)ExceptionMessage.LINEAGE_DOES_NOT_EXIST, (Object[])new Object[]{lineageId});
        Lineage toDelete = this.mIdIndex.get(lineageId);
        for (Lineage childLineage : this.mLineageDAG.getChildren((Object)toDelete)) {
            this.deleteLineage(childLineage.getId());
        }
        this.mLineageDAG.deleteLeaf((Object)toDelete);
        this.mIdIndex.remove(lineageId);
        Iterator<Object> i$ = toDelete.getOutputFiles().iterator();
        while (i$.hasNext()) {
            long outputFile = (Long)i$.next();
            this.mOutputFileIndex.remove(outputFile);
        }
    }

    public synchronized Lineage getLineage(long lineageId) {
        return this.mIdIndex.get(lineageId);
    }

    public synchronized List<Lineage> getChildren(Lineage lineage) throws LineageDoesNotExistException {
        LineageDoesNotExistException.check((boolean)this.mIdIndex.containsKey(lineage.getId()), (ExceptionMessage)ExceptionMessage.LINEAGE_DOES_NOT_EXIST, (Object[])new Object[]{lineage.getId()});
        return this.mLineageDAG.getChildren((Object)lineage);
    }

    public synchronized Lineage getLineageOfOutputFile(long fileId) throws LineageDoesNotExistException {
        Lineage lineage = this.mOutputFileIndex.get(fileId);
        LineageDoesNotExistException.check((lineage != null ? 1 : 0) != 0, (ExceptionMessage)ExceptionMessage.LINEAGE_DOES_NOT_EXIST, (Object[])new Object[]{fileId});
        return lineage;
    }

    public synchronized List<Lineage> getParents(Lineage lineage) throws LineageDoesNotExistException {
        LineageDoesNotExistException.check((boolean)this.mIdIndex.containsKey(lineage.getId()), (ExceptionMessage)ExceptionMessage.LINEAGE_DOES_NOT_EXIST, (Object[])new Object[]{lineage.getId()});
        return this.mLineageDAG.getParents((Object)lineage);
    }

    public synchronized List<Lineage> getRootLineages() {
        return this.mLineageDAG.getRoots();
    }

    public synchronized List<Lineage> sortLineageTopologically(Set<Lineage> lineages) {
        return this.mLineageDAG.sortTopologically(lineages);
    }

    public synchronized List<Lineage> getAllInTopologicalOrder() {
        return this.mLineageDAG.getAllInTopologicalOrder();
    }

    @Override
    public synchronized void streamToJournalCheckpoint(JournalOutputStream outputStream) throws IOException {
        for (Lineage lineage : this.mLineageDAG.getAllInTopologicalOrder()) {
            outputStream.writeEntry(lineage.toJournalEntry());
        }
    }

    public synchronized boolean hasOutputFile(long fileId) {
        return this.mOutputFileIndex.containsKey(fileId);
    }
}

