/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.lineage.recompute;

import alluxio.exception.AccessControlException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.lineage.meta.Lineage;
import alluxio.master.lineage.meta.LineageStateUtils;
import alluxio.master.lineage.recompute.RecomputePlan;
import alluxio.master.lineage.recompute.RecomputePlanner;
import alluxio.util.ThreadFactoryUtils;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class RecomputeExecutor
implements HeartbeatExecutor {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final int DEFAULT_RECOMPUTE_LAUNCHER_POOL_SIZE = 10;
    private final RecomputePlanner mPlanner;
    private final FileSystemMaster mFileSystemMaster;
    private final ExecutorService mRecomputeLauncherService = Executors.newFixedThreadPool(10, ThreadFactoryUtils.build((String)"recompute-launcher-%d", (boolean)true));

    public RecomputeExecutor(RecomputePlanner planner, FileSystemMaster fileSystemMaster) {
        this.mPlanner = (RecomputePlanner)Preconditions.checkNotNull((Object)planner);
        this.mFileSystemMaster = (FileSystemMaster)Preconditions.checkNotNull((Object)fileSystemMaster);
    }

    public void heartbeat() {
        this.heartbeatWithFuture();
    }

    public void close() {
        this.mRecomputeLauncherService.shutdown();
    }

    Future<?> heartbeatWithFuture() {
        RecomputePlan plan = this.mPlanner.plan();
        if (plan != null && !plan.isEmpty()) {
            return this.mRecomputeLauncherService.submit(new RecomputeLauncher(plan));
        }
        return Futures.immediateFuture(null);
    }

    @ThreadSafe
    final class RecomputeLauncher
    implements Runnable {
        private final RecomputePlan mPlan;

        RecomputeLauncher(RecomputePlan plan) {
            this.mPlan = (RecomputePlan)Preconditions.checkNotNull((Object)plan);
        }

        @Override
        public void run() {
            for (Lineage lineage : this.mPlan.getLineageToRecompute()) {
                boolean success;
                try {
                    for (Long fileId : LineageStateUtils.getLostFiles(lineage, RecomputeExecutor.this.mFileSystemMaster.getFileSystemMasterView())) {
                        try {
                            RecomputeExecutor.this.mFileSystemMaster.resetFile(fileId);
                        }
                        catch (FileDoesNotExistException e) {
                            LOG.error("the lost file {} does not exist", (Object)fileId, (Object)e);
                        }
                        catch (InvalidPathException e) {
                            LOG.error("the lost file {} is invalid", (Object)fileId, (Object)e);
                        }
                        catch (AccessControlException e) {
                            LOG.error("the lost file {} cannot be accessed", (Object)fileId, (Object)e);
                        }
                    }
                }
                catch (FileDoesNotExistException e) {
                    LOG.error("an output file of lineage {} does not exist", (Object)lineage.getId(), (Object)e);
                }
                if (success = lineage.getJob().run()) continue;
                LOG.error("Failed to recompute job {}", (Object)lineage.getJob());
            }
        }
    }
}

