/*
 * Decompiled with CFR 0.152.
 */
package alluxio.master.lineage.recompute;

import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.LineageDoesNotExistException;
import alluxio.master.file.FileSystemMaster;
import alluxio.master.lineage.meta.Lineage;
import alluxio.master.lineage.meta.LineageStateUtils;
import alluxio.master.lineage.meta.LineageStore;
import alluxio.master.lineage.recompute.RecomputePlan;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RecomputePlanner {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final LineageStore mLineageStore;
    private final FileSystemMaster mFileSystemMaster;

    public RecomputePlanner(LineageStore lineageStore, FileSystemMaster fileSystemMaster) {
        this.mLineageStore = (LineageStore)Preconditions.checkNotNull((Object)lineageStore);
        this.mFileSystemMaster = (FileSystemMaster)Preconditions.checkNotNull((Object)fileSystemMaster);
    }

    public RecomputePlan plan() {
        List<Long> lostFiles = this.mFileSystemMaster.getLostFiles();
        HashSet toRecompute = Sets.newHashSet();
        if (!lostFiles.isEmpty()) {
            LOG.info("report lost files {}", lostFiles);
            for (long lostFile : lostFiles) {
                Lineage lineage;
                if (!this.mLineageStore.hasOutputFile(lostFile)) continue;
                try {
                    lineage = this.mLineageStore.getLineageOfOutputFile(lostFile);
                }
                catch (LineageDoesNotExistException e) {
                    throw new IllegalStateException(e);
                }
                try {
                    if (LineageStateUtils.isPersisted(lineage, this.mFileSystemMaster.getFileSystemMasterView())) continue;
                    toRecompute.add(lineage);
                }
                catch (FileDoesNotExistException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        List<Lineage> toRecomputeAfterSort = this.mLineageStore.sortLineageTopologically(toRecompute);
        return new RecomputePlan(toRecomputeAfterSort);
    }
}

