/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class MetricsConfig {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final String DEFAULT_PREFIX = "*";
    private static final String INSTANCE_REGEX = "^(\\*|[a-zA-Z]+)\\.(.+)";
    private static final String METRICS_CONF = "metrics.properties";
    private String mConfigFile;
    private Properties mProperties;
    private Map<String, Properties> mPropertyCategories;

    public MetricsConfig(String configFile) {
        this.mConfigFile = configFile;
        this.mProperties = new Properties();
        this.setDefaultProperties();
        this.loadConfigFile();
        this.parseConfiguration();
    }

    public MetricsConfig(Properties properties) {
        this.mProperties = new Properties();
        this.setDefaultProperties();
        this.mProperties.putAll((Map<?, ?>)properties);
        this.parseConfiguration();
    }

    private void addDefaultProperties(Properties prop, Properties defaultProp) {
        for (Map.Entry<Object, Object> entry : defaultProp.entrySet()) {
            String key = entry.getKey().toString();
            if (prop.getProperty(key) != null) continue;
            prop.setProperty(key, entry.getValue().toString());
        }
    }

    public Properties getInstanceProperties(String inst) {
        Properties prop = this.mPropertyCategories.get(inst);
        if (prop == null && (prop = this.mPropertyCategories.get(DEFAULT_PREFIX)) == null) {
            prop = new Properties();
        }
        return prop;
    }

    public Map<String, Properties> getPropertyCategories() {
        return this.mPropertyCategories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigFile() {
        InputStream is = null;
        try {
            is = this.mConfigFile != null ? new FileInputStream(this.mConfigFile) : this.getClass().getClassLoader().getResourceAsStream(METRICS_CONF);
            if (is != null) {
                this.mProperties.load(is);
            }
        }
        catch (Exception e) {
            LOG.error("Error loading metrics configuration file.");
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void parseConfiguration() {
        this.mPropertyCategories = this.subProperties(this.mProperties, INSTANCE_REGEX);
        if (this.mPropertyCategories.containsKey(DEFAULT_PREFIX)) {
            Properties defaultProperties = this.mPropertyCategories.get(DEFAULT_PREFIX);
            for (Map.Entry<String, Properties> entry : this.mPropertyCategories.entrySet()) {
                if (entry.getKey().equals(DEFAULT_PREFIX)) continue;
                this.addDefaultProperties(entry.getValue(), defaultProperties);
            }
        }
    }

    private void setDefaultProperties() {
        this.mProperties.setProperty("*.sink.servlet.class", "alluxio.metrics.sink.MetricsServlet");
        this.mProperties.setProperty("*.sink.servlet.path", "/metrics/json");
    }

    public Map<String, Properties> subProperties(Properties prop, String regex) {
        HashMap<String, Properties> subProperties = new HashMap<String, Properties>();
        Pattern pattern = Pattern.compile(regex);
        for (Map.Entry<Object, Object> entry : prop.entrySet()) {
            Matcher m = pattern.matcher(entry.getKey().toString());
            if (!m.find()) continue;
            String prefix = m.group(1);
            String suffix = m.group(2);
            if (!subProperties.containsKey(prefix)) {
                subProperties.put(prefix, new Properties());
            }
            ((Properties)subProperties.get(prefix)).put(suffix, entry.getValue());
        }
        return subProperties;
    }
}

