/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics;

import alluxio.Configuration;
import alluxio.metrics.MetricsConfig;
import alluxio.metrics.sink.MetricsServlet;
import alluxio.metrics.sink.Sink;
import alluxio.metrics.source.Source;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class MetricsSystem {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    public static final String SINK_REGEX = "^sink\\.(.+)\\.(.+)";
    public static final String SOURCE_REGEX = "^source\\.(.+)\\.(.+)";
    private static final TimeUnit MINIMAL_POLL_UNIT = TimeUnit.SECONDS;
    private static final int MINIMAL_POLL_PERIOD = 1;
    private String mInstance;
    private List<Sink> mSinks = new ArrayList<Sink>();
    private List<Source> mSources = new ArrayList<Source>();
    private MetricRegistry mMetricRegistry = new MetricRegistry();
    private MetricsConfig mMetricsConfig;
    private boolean mRunning = false;
    private Configuration mConfiguration;
    private MetricsServlet mMetricsServlet;

    public List<Sink> getSinks() {
        return this.mSinks;
    }

    public List<Source> getSources() {
        return this.mSources;
    }

    public static void checkMinimalPollingPeriod(TimeUnit pollUnit, int pollPeriod) throws IllegalArgumentException {
        int period = (int)MINIMAL_POLL_UNIT.convert(pollPeriod, pollUnit);
        if (period < 1) {
            throw new IllegalArgumentException("Polling period " + pollPeriod + " " + (Object)((Object)pollUnit) + " is below than minimal polling period");
        }
    }

    public MetricsSystem(String instance, Configuration configuration) {
        this.mInstance = instance;
        this.mConfiguration = configuration;
        String metricsConfFile = null;
        metricsConfFile = this.mConfiguration.get("alluxio.metrics.conf.file");
        this.mMetricsConfig = new MetricsConfig(metricsConfFile);
    }

    public MetricsSystem(String instance, MetricsConfig metricsConfig, Configuration configuration) {
        this.mInstance = instance;
        this.mMetricsConfig = metricsConfig;
        this.mConfiguration = configuration;
    }

    public ServletContextHandler getServletHandler() {
        if (this.mRunning && this.mMetricsServlet != null) {
            return this.mMetricsServlet.getHandler();
        }
        return null;
    }

    public void registerSource(Source source) {
        this.mSources.add(source);
        try {
            this.mMetricRegistry.register(source.getName(), (Metric)source.getMetricRegistry());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Metrics already registered. Exception: {}", (Object)e.getMessage());
        }
    }

    private void registerSources() {
        Properties instConfig = this.mMetricsConfig.getInstanceProperties(this.mInstance);
        Map<String, Properties> sourceConfigs = this.mMetricsConfig.subProperties(instConfig, SOURCE_REGEX);
        for (Map.Entry<String, Properties> entry : sourceConfigs.entrySet()) {
            String classPath = entry.getValue().getProperty("class");
            if (classPath == null) continue;
            try {
                Source source = (Source)Class.forName(classPath).newInstance();
                this.registerSource(source);
            }
            catch (Exception e) {
                LOG.error("Source class {} cannot be instantiated", (Object)classPath, (Object)e);
            }
        }
    }

    private void registerSinks() {
        Properties instConfig = this.mMetricsConfig.getInstanceProperties(this.mInstance);
        Map<String, Properties> sinkConfigs = this.mMetricsConfig.subProperties(instConfig, SINK_REGEX);
        for (Map.Entry<String, Properties> entry : sinkConfigs.entrySet()) {
            String classPath = entry.getValue().getProperty("class");
            if (classPath == null) continue;
            try {
                Sink sink = (Sink)Class.forName(classPath).getConstructor(Properties.class, MetricRegistry.class).newInstance(entry.getValue(), this.mMetricRegistry);
                if (entry.getKey().equals("servlet")) {
                    this.mMetricsServlet = (MetricsServlet)sink;
                    continue;
                }
                this.mSinks.add(sink);
            }
            catch (Exception e) {
                LOG.error("Sink class {} cannot be instantiated", (Object)classPath, (Object)e);
            }
        }
    }

    public void removeSource(Source source) {
        this.mSources.remove(source);
        this.mMetricRegistry.remove(source.getName());
    }

    public void report() {
        for (Sink sink : this.mSinks) {
            sink.report();
        }
    }

    public void start() {
        if (!this.mRunning) {
            this.registerSources();
            this.registerSinks();
            for (Sink sink : this.mSinks) {
                sink.start();
            }
            this.mRunning = true;
        } else {
            LOG.warn("Attempting to start a MetricsSystem that is already running");
        }
    }

    public void stop() {
        if (this.mRunning) {
            for (Sink sink : this.mSinks) {
                sink.stop();
            }
            this.mRunning = false;
        } else {
            LOG.warn("Stopping a MetricsSystem that is not running");
        }
    }
}

