/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.sink;

import alluxio.metrics.MetricsSystem;
import alluxio.metrics.sink.Sink;
import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricRegistry;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class ConsoleSink
implements Sink {
    private static final int CONSOLE_DEFAULT_PERIOD = 10;
    private static final String CONSOLE_DEFAULT_UNIT = "SECONDS";
    private static final String CONSOLE_KEY_PERIOD = "period";
    private static final String CONSOLE_KEY_UNIT = "unit";
    private ConsoleReporter mReporter;
    private Properties mProperties;

    public ConsoleSink(Properties properties, MetricRegistry registry) {
        this.mProperties = properties;
        this.mReporter = ConsoleReporter.forRegistry((MetricRegistry)registry).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).build();
        MetricsSystem.checkMinimalPollingPeriod(this.getPollUnit(), this.getPollPeriod());
    }

    public int getPollPeriod() {
        String period = this.mProperties.getProperty(CONSOLE_KEY_PERIOD);
        return period != null ? Integer.parseInt(period) : 10;
    }

    public TimeUnit getPollUnit() {
        String unit = this.mProperties.getProperty(CONSOLE_KEY_UNIT);
        if (unit == null) {
            unit = CONSOLE_DEFAULT_UNIT;
        }
        return TimeUnit.valueOf(unit.toUpperCase());
    }

    @Override
    public void start() {
        this.mReporter.start((long)this.getPollPeriod(), this.getPollUnit());
    }

    @Override
    public void stop() {
        this.mReporter.stop();
    }

    @Override
    public void report() {
        this.mReporter.report();
    }
}

