/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.sink;

import alluxio.metrics.MetricsSystem;
import alluxio.metrics.sink.Sink;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class GraphiteSink
implements Sink {
    private static final int GRAPHITE_DEFAULT_PERIOD = 10;
    private static final String GRAPHITE_DEFAULT_UNIT = "SECONDS";
    private static final String GRAPHITE_DEFAULT_PREFIX = "";
    private static final String GRAPHITE_KEY_HOST = "host";
    private static final String GRAPHITE_KEY_PORT = "port";
    private static final String GRAPHITE_KEY_PERIOD = "period";
    private static final String GRAPHITE_KEY_UNIT = "unit";
    private static final String GRAPHITE_KEY_PREFIX = "prefix";
    private GraphiteReporter mReporter;
    private Properties mProperties;

    public GraphiteSink(Properties properties, MetricRegistry registry) throws IllegalArgumentException {
        this.mProperties = properties;
        String host = properties.getProperty(GRAPHITE_KEY_HOST);
        String port = properties.getProperty(GRAPHITE_KEY_PORT);
        if (host == null || port == null) {
            throw new IllegalArgumentException("Graphite sink requires 'host' and 'port' properties");
        }
        String prefix = properties.getProperty(GRAPHITE_KEY_PREFIX);
        if (prefix == null) {
            prefix = GRAPHITE_DEFAULT_PREFIX;
        }
        Graphite graphite = new Graphite(host, Integer.parseInt(port));
        this.mReporter = GraphiteReporter.forRegistry((MetricRegistry)registry).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).prefixedWith(prefix).build((GraphiteSender)graphite);
        MetricsSystem.checkMinimalPollingPeriod(this.getPollUnit(), this.getPollPeriod());
    }

    public int getPollPeriod() {
        String period = this.mProperties.getProperty(GRAPHITE_KEY_PERIOD);
        return period != null ? Integer.parseInt(period) : 10;
    }

    public TimeUnit getPollUnit() {
        String unit = this.mProperties.getProperty(GRAPHITE_KEY_UNIT);
        if (unit == null) {
            unit = GRAPHITE_DEFAULT_UNIT;
        }
        return TimeUnit.valueOf(unit.toUpperCase());
    }

    @Override
    public void start() {
        this.mReporter.start((long)this.getPollPeriod(), this.getPollUnit());
    }

    @Override
    public void stop() {
        this.mReporter.stop();
    }

    @Override
    public void report() {
        this.mReporter.report();
    }
}

