/*
 * Decompiled with CFR 0.152.
 */
package alluxio.metrics.sink;

import alluxio.metrics.sink.Sink;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

@NotThreadSafe
public class MetricsServlet
implements Sink {
    private static final String SERVLET_KEY_PATH = "path";
    private Properties mProperties;
    private MetricRegistry mMetricsRegistry;
    private ObjectMapper mObjectMapper;

    public MetricsServlet(Properties properties, MetricRegistry registry) {
        this.mProperties = properties;
        this.mMetricsRegistry = registry;
        this.mObjectMapper = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false));
    }

    private HttpServlet createServlet() {
        return new HttpServlet(){
            private static final long serialVersionUID = -2761243531478788172L;

            protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
                response.setContentType(String.format("text/json;charset=utf-8", new Object[0]));
                response.setStatus(200);
                response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
                String result = MetricsServlet.this.mObjectMapper.writeValueAsString((Object)MetricsServlet.this.mMetricsRegistry);
                response.getWriter().println(result);
            }
        };
    }

    public ServletContextHandler getHandler() {
        ServletContextHandler contextHandler = new ServletContextHandler();
        String servletPath = this.mProperties.getProperty(SERVLET_KEY_PATH);
        contextHandler.setContextPath(servletPath);
        contextHandler.addServlet(new ServletHolder((Servlet)this.createServlet()), "/");
        return contextHandler;
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void report() {
    }
}

