/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.Configuration;
import alluxio.master.AlluxioMaster;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.web.UIWebServer;
import alluxio.web.WebInterfaceBrowseLogsServlet;
import alluxio.web.WebInterfaceBrowseServlet;
import alluxio.web.WebInterfaceConfigurationServlet;
import alluxio.web.WebInterfaceDependencyServlet;
import alluxio.web.WebInterfaceDownloadLocalServlet;
import alluxio.web.WebInterfaceDownloadServlet;
import alluxio.web.WebInterfaceGeneralServlet;
import alluxio.web.WebInterfaceHeaderServlet;
import alluxio.web.WebInterfaceMemoryServlet;
import alluxio.web.WebInterfaceWorkersServlet;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletHolder;

@NotThreadSafe
public final class MasterUIWebServer
extends UIWebServer {
    public MasterUIWebServer(NetworkAddressUtils.ServiceType service, InetSocketAddress address, AlluxioMaster master, Configuration conf) {
        super(service, address, conf);
        Preconditions.checkNotNull((Object)master, (Object)"AlluxioMaster cannot be null");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceGeneralServlet(master)), "/home");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceWorkersServlet(master.getBlockMaster())), "/workers");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceConfigurationServlet(master.getFileSystemMaster())), "/configuration");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceBrowseServlet(master)), "/browse");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceMemoryServlet(master)), "/memory");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceDependencyServlet(master)), "/dependency");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceDownloadServlet(master.getFileSystemMaster())), "/download");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceDownloadLocalServlet()), "/downloadLocal");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceBrowseLogsServlet(true)), "/browseLogs");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceHeaderServlet(conf)), "/header");
    }
}

