/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.wire.BlockLocation;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class UIFileBlockInfo {
    private final List<String> mLocations = new ArrayList<String>();
    private final Set<String> mTierAliases = new HashSet<String>();
    private final long mId;
    private final long mBlockLength;
    private final long mLastAccessTimeMs;

    public UIFileBlockInfo(FileBlockInfo fileBlockInfo) {
        Preconditions.checkNotNull((Object)fileBlockInfo);
        this.mId = fileBlockInfo.getBlockInfo().getBlockId();
        this.mBlockLength = fileBlockInfo.getBlockInfo().getLength();
        this.mLastAccessTimeMs = -1L;
        this.addLocations(fileBlockInfo);
        for (BlockLocation location : fileBlockInfo.getBlockInfo().getLocations()) {
            this.mTierAliases.add(location.getTierAlias());
        }
    }

    public UIFileBlockInfo(long blockId, long blockLength, long blockLastAccessTimeMs, String tierAlias) {
        this.mId = blockId;
        this.mBlockLength = blockLength;
        this.mLastAccessTimeMs = blockLastAccessTimeMs;
        this.mTierAliases.add(tierAlias);
    }

    private void addLocations(FileBlockInfo fileBlockInfo) {
        HashSet locations = Sets.newHashSet();
        for (BlockLocation location : fileBlockInfo.getBlockInfo().getLocations()) {
            locations.add(location.getWorkerAddress().getHost());
        }
        for (WorkerNetAddress address : fileBlockInfo.getUfsLocations()) {
            locations.add(address.getHost());
        }
        this.mLocations.addAll(locations);
    }

    public boolean isInTier(String tierAlias) {
        return this.mTierAliases.contains(tierAlias);
    }

    public long getBlockLength() {
        return this.mBlockLength;
    }

    public long getID() {
        return this.mId;
    }

    public long getLastAccessTimeMs() {
        return this.mLastAccessTimeMs;
    }

    public List<String> getLocations() {
        return this.mLocations;
    }
}

