/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.client.file.URIStatus;
import alluxio.master.file.meta.PersistenceState;
import alluxio.security.authorization.FileSystemPermission;
import alluxio.util.FormatUtils;
import alluxio.web.UIFileBlockInfo;
import alluxio.web.WebUtils;
import alluxio.wire.FileInfo;
import alluxio.wire.WorkerNetAddress;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class UIFileInfo {
    public static final Ordering<UIFileInfo> PATH_STRING_COMPARE = Ordering.natural().onResultOf((Function)new Function<UIFileInfo, Comparable<String>>(){

        public Comparable<String> apply(UIFileInfo input) {
            return input.mAbsolutePath;
        }
    });
    private final long mId;
    private final String mName;
    private final String mAbsolutePath;
    private final long mBlockSizeBytes;
    private final long mSize;
    private final long mCreationTimeMs;
    private final long mLastModificationTimeMs;
    private final boolean mInMemory;
    private final int mInMemoryPercent;
    private final boolean mIsDirectory;
    private final boolean mPinned;
    private final String mUserName;
    private final String mGroupName;
    private final String mPermission;
    private final String mPersistenceState;
    private final List<String> mFileLocations;
    private final Map<String, List<UIFileBlockInfo>> mBlocksOnTier = new HashMap<String, List<UIFileBlockInfo>>();
    private final Map<String, Long> mSizeOnTier = new HashMap<String, Long>();

    public UIFileInfo(URIStatus status) {
        this.mId = status.getFileId();
        this.mName = status.getName();
        this.mAbsolutePath = status.getPath();
        this.mBlockSizeBytes = status.getBlockSizeBytes();
        this.mSize = status.getLength();
        this.mCreationTimeMs = status.getCreationTimeMs();
        this.mLastModificationTimeMs = status.getLastModificationTimeMs();
        this.mInMemory = 100 == status.getInMemoryPercentage();
        this.mInMemoryPercent = status.getInMemoryPercentage();
        this.mIsDirectory = status.isFolder();
        this.mPinned = status.isPinned();
        this.mUserName = status.getUserName();
        this.mGroupName = status.getGroupName();
        this.mPermission = FormatUtils.formatPermission((short)((short)status.getPermission()), (boolean)status.isFolder());
        this.mPersistenceState = status.getPersistenceState();
        this.mFileLocations = new ArrayList<String>();
    }

    public UIFileInfo(FileInfo info) {
        this(new URIStatus(info));
    }

    public UIFileInfo(LocalFileInfo fileInfo) {
        this.mId = -1L;
        this.mName = fileInfo.mName;
        this.mAbsolutePath = fileInfo.mAbsolutePath;
        this.mBlockSizeBytes = 0L;
        this.mSize = fileInfo.mSize;
        this.mCreationTimeMs = fileInfo.mCreationTimeMs;
        this.mLastModificationTimeMs = fileInfo.mLastModificationTimeMs;
        this.mInMemory = false;
        this.mInMemoryPercent = 0;
        this.mIsDirectory = fileInfo.mIsDirectory;
        this.mPinned = false;
        this.mUserName = "";
        this.mGroupName = "";
        this.mPermission = FormatUtils.formatPermission((short)FileSystemPermission.getNoneFsPermission().toShort(), (boolean)true);
        this.mPersistenceState = PersistenceState.NOT_PERSISTED.name();
        this.mFileLocations = new ArrayList<String>();
    }

    public void addBlock(String tierAlias, long blockId, long blockSize, long blockLastAccessTimeMs) {
        UIFileBlockInfo block = new UIFileBlockInfo(blockId, blockSize, blockLastAccessTimeMs, tierAlias);
        List<UIFileBlockInfo> blocksOnTier = this.mBlocksOnTier.get(tierAlias);
        if (blocksOnTier == null) {
            blocksOnTier = new ArrayList<UIFileBlockInfo>();
            this.mBlocksOnTier.put(tierAlias, blocksOnTier);
        }
        blocksOnTier.add(block);
        Long sizeOnTier = this.mSizeOnTier.get(tierAlias);
        this.mSizeOnTier.put(tierAlias, (sizeOnTier == null ? 0L : sizeOnTier) + blockSize);
    }

    public String getAbsolutePath() {
        return this.mAbsolutePath;
    }

    public String getBlockSizeBytes() {
        if (this.mIsDirectory) {
            return "";
        }
        return FormatUtils.getSizeFromBytes((long)this.mBlockSizeBytes);
    }

    public Map<String, List<UIFileBlockInfo>> getBlocksOnTier() {
        return this.mBlocksOnTier;
    }

    public String getCreationTime() {
        if (this.mCreationTimeMs == 0L) {
            return "";
        }
        return WebUtils.convertMsToDate(this.mCreationTimeMs);
    }

    public String getModificationTime() {
        return WebUtils.convertMsToDate(this.mLastModificationTimeMs);
    }

    public List<String> getFileLocations() {
        return this.mFileLocations;
    }

    public long getId() {
        return this.mId;
    }

    public boolean getInMemory() {
        return this.mInMemory;
    }

    public int getInMemoryPercentage() {
        return this.mInMemoryPercent;
    }

    public boolean getIsDirectory() {
        return this.mIsDirectory;
    }

    public boolean isPinned() {
        return this.mPinned;
    }

    public String getPersistenceState() {
        return this.mPersistenceState;
    }

    public int getOnTierPercentage(String tierAlias) {
        Long sizeOnTier = this.mSizeOnTier.containsKey(tierAlias) ? this.mSizeOnTier.get(tierAlias) : 0L;
        return (int)(100L * sizeOnTier / this.mSize);
    }

    public String getName() {
        if ("/".equals(this.mAbsolutePath)) {
            return "root";
        }
        return this.mName;
    }

    public String getSize() {
        if (this.mIsDirectory) {
            return "";
        }
        return FormatUtils.getSizeFromBytes((long)this.mSize);
    }

    public void setFileLocations(List<WorkerNetAddress> fileLocations) {
        for (WorkerNetAddress addr : fileLocations) {
            this.mFileLocations.add(addr.getHost() + ":" + addr.getRpcPort());
        }
    }

    public String getUserName() {
        return this.mUserName;
    }

    public String getGroupName() {
        return this.mGroupName;
    }

    public String getPermission() {
        return this.mPermission;
    }

    @ThreadSafe
    static class LocalFileInfo {
        public static final long EMPTY_CREATION_TIME = 0L;
        private final String mName;
        private final String mAbsolutePath;
        private final long mSize;
        private final long mCreationTimeMs;
        private final long mLastModificationTimeMs;
        private final boolean mIsDirectory;

        public LocalFileInfo(String name, String absolutePath, long size, long creationTimeMs, long lastModificationTimeMs, boolean isDirectory) {
            this.mName = (String)Preconditions.checkNotNull((Object)name);
            this.mAbsolutePath = (String)Preconditions.checkNotNull((Object)absolutePath);
            this.mSize = size;
            this.mCreationTimeMs = creationTimeMs;
            this.mLastModificationTimeMs = lastModificationTimeMs;
            this.mIsDirectory = isDirectory;
        }
    }
}

