/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.Configuration;
import alluxio.util.network.NetworkAddressUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.File;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.NotThreadSafe;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public abstract class UIWebServer {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    protected final WebAppContext mWebAppContext;
    private final Server mServer;
    private final NetworkAddressUtils.ServiceType mService;
    private final Configuration mConfiguration;
    private InetSocketAddress mAddress;

    public UIWebServer(NetworkAddressUtils.ServiceType service, InetSocketAddress address, Configuration conf) {
        Preconditions.checkNotNull((Object)service, (Object)"Service type cannot be null");
        Preconditions.checkNotNull((Object)address, (Object)"Server address cannot be null");
        Preconditions.checkNotNull((Object)conf, (Object)"Configuration cannot be null");
        this.mAddress = address;
        this.mService = service;
        this.mConfiguration = conf;
        QueuedThreadPool threadPool = new QueuedThreadPool();
        int webThreadCount = this.mConfiguration.getInt("alluxio.web.threads");
        this.mServer = new Server();
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setHost(address.getHostName());
        connector.setPort(address.getPort());
        connector.setAcceptors(webThreadCount);
        this.mServer.setConnectors(new Connector[]{connector});
        threadPool.setMinThreads(webThreadCount * 2 + 1);
        threadPool.setMaxThreads(webThreadCount * 2 + 100);
        this.mServer.setThreadPool((ThreadPool)threadPool);
        this.mWebAppContext = new WebAppContext();
        this.mWebAppContext.setContextPath("/");
        File warPath = new File(this.mConfiguration.get("alluxio.web.resources"));
        this.mWebAppContext.setWar(warPath.getAbsolutePath());
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{this.mWebAppContext, new DefaultHandler()});
        this.mServer.setHandler((Handler)handlers);
    }

    public void addHandler(AbstractHandler handler) {
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)handler);
        for (Handler h : this.mServer.getHandlers()) {
            handlers.addHandler(h);
        }
        this.mServer.setHandler((Handler)handlers);
    }

    public void setHandler(AbstractHandler handler) {
        this.mServer.setHandler((Handler)handler);
    }

    public Server getServer() {
        return this.mServer;
    }

    public String getBindHost() {
        String bindHost = this.mServer.getServer().getConnectors()[0].getHost();
        return bindHost == null ? "0.0.0.0" : bindHost;
    }

    public int getLocalPort() {
        return this.mServer.getServer().getConnectors()[0].getLocalPort();
    }

    public void shutdownWebServer() throws Exception {
        for (Connector connector : this.mServer.getConnectors()) {
            connector.close();
        }
        this.mServer.stop();
    }

    public void startWebServer() {
        try {
            this.mServer.getConnectors()[0].close();
            this.mServer.getConnectors()[0].open();
            this.mServer.start();
            if (this.mAddress.getPort() == 0) {
                int webPort = this.mServer.getConnectors()[0].getLocalPort();
                this.mAddress = new InetSocketAddress(this.mAddress.getHostName(), webPort);
                this.mConfiguration.set(this.mService.getPortKey(), Integer.toString(webPort));
            }
            LOG.info("{} started @ {}", (Object)this.mService.getServiceName(), (Object)this.mAddress);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

