/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.Configuration;
import alluxio.master.MasterContext;
import alluxio.web.UIFileInfo;
import alluxio.web.WebUtils;
import alluxio.worker.WorkerContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ThreadSafe
public final class WebInterfaceBrowseLogsServlet
extends HttpServlet {
    private static final long serialVersionUID = 6589358568781503724L;
    private final transient Configuration mConfiguration;
    private final String mBrowseJsp;
    private final String mViewJsp;
    private static final FilenameFilter LOG_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".log");
        }
    };

    public WebInterfaceBrowseLogsServlet(boolean isMasterServlet) {
        this.mConfiguration = isMasterServlet ? MasterContext.getConf() : WorkerContext.getConf();
        String prefix = isMasterServlet ? "/" : "/worker/";
        this.mBrowseJsp = prefix + "browse.jsp";
        this.mViewJsp = prefix + "viewFile.jsp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayLocalFile(File file, HttpServletRequest request, long offset) throws IOException {
        String fileData = null;
        try (FileInputStream is = new FileInputStream(file);){
            int read;
            long fileSize = file.length();
            int len = (int)Math.min(5120L, fileSize - offset);
            byte[] data = new byte[len];
            long skipped = ((InputStream)is).skip(offset);
            fileData = skipped < 0L ? "Unable to traverse to offset; is file empty?" : (skipped < offset ? "Unable to traverse to offset; is offset larger than the file?" : ((read = ((InputStream)is).read(data, 0, len)) < 0 ? "Unable to read file" : WebUtils.convertByteArrayToStringWithoutEscape(data, 0, read)));
        }
        request.setAttribute("fileData", (Object)fileData);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("debug", (Object)this.mConfiguration.getBoolean("alluxio.debug"));
        request.setAttribute("invalidPathError", (Object)"");
        request.setAttribute("viewingOffset", (Object)0);
        request.setAttribute("downloadLogFile", (Object)1);
        request.setAttribute("baseUrl", (Object)"./browseLogs");
        request.setAttribute("currentPath", (Object)"");
        request.setAttribute("showPermissions", (Object)false);
        String logsPath = this.mConfiguration.get("alluxio.logs.dir");
        File logsDir = new File(logsPath);
        String requestFile = request.getParameter("path");
        if (requestFile == null || requestFile.isEmpty()) {
            File[] logFiles;
            ArrayList<UIFileInfo> fileInfos = new ArrayList<UIFileInfo>();
            for (File logFile : logFiles = logsDir.listFiles(LOG_FILE_FILTER)) {
                String logFileName = logFile.getName();
                fileInfos.add(new UIFileInfo(new UIFileInfo.LocalFileInfo(logFileName, logFileName, logFile.length(), 0L, logFile.lastModified(), logFile.isDirectory())));
            }
            Collections.sort(fileInfos, UIFileInfo.PATH_STRING_COMPARE);
            request.setAttribute("nTotalFile", (Object)fileInfos.size());
            if (request.getParameter("offset") == null && request.getParameter("limit") == null) {
                this.getServletContext().getRequestDispatcher(this.mBrowseJsp).forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            try {
                int offset = Integer.parseInt(request.getParameter("offset"));
                int limit = Integer.parseInt(request.getParameter("limit"));
                List sub = fileInfos.subList(offset, offset + limit);
                request.setAttribute("fileInfos", sub);
            }
            catch (NumberFormatException e) {
                request.setAttribute("fatalError", (Object)("Error: offset or limit parse error, " + e.getLocalizedMessage()));
                this.getServletContext().getRequestDispatcher(this.mBrowseJsp).forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                request.setAttribute("fatalError", (Object)("Error: offset or offset + limit is out of bound, " + e.getLocalizedMessage()));
                this.getServletContext().getRequestDispatcher(this.mBrowseJsp).forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            catch (IllegalArgumentException e) {
                request.setAttribute("fatalError", (Object)e.getLocalizedMessage());
                this.getServletContext().getRequestDispatcher(this.mBrowseJsp).forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            this.getServletContext().getRequestDispatcher(this.mBrowseJsp).forward((ServletRequest)request, (ServletResponse)response);
        } else {
            requestFile = new File(requestFile).getName();
            request.setAttribute("currentPath", (Object)requestFile);
            File logFile = new File(logsDir, requestFile);
            try {
                long fileSize = logFile.length();
                String offsetParam = request.getParameter("offset");
                long relativeOffset = 0L;
                try {
                    if (offsetParam != null) {
                        relativeOffset = Long.parseLong(offsetParam);
                    }
                }
                catch (NumberFormatException e) {
                    relativeOffset = 0L;
                }
                String endParam = request.getParameter("end");
                long offset = endParam == null ? relativeOffset : fileSize - relativeOffset;
                if (offset < 0L) {
                    offset = 0L;
                } else if (offset > fileSize) {
                    offset = fileSize;
                }
                this.displayLocalFile(logFile, request, offset);
                request.setAttribute("viewingOffset", (Object)offset);
                this.getServletContext().getRequestDispatcher(this.mViewJsp).forward((ServletRequest)request, (ServletResponse)response);
            }
            catch (IOException e) {
                request.setAttribute("invalidPathError", (Object)("Error: File " + logFile + " is not available " + e.getMessage()));
                this.getServletContext().getRequestDispatcher(this.mViewJsp).forward((ServletRequest)request, (ServletResponse)response);
            }
        }
    }
}

