/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.ReadType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.exception.AccessControlException;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.master.AlluxioMaster;
import alluxio.master.MasterContext;
import alluxio.security.LoginUser;
import alluxio.security.authentication.PlainSaslServer;
import alluxio.util.SecurityUtils;
import alluxio.util.io.PathUtils;
import alluxio.web.UIFileBlockInfo;
import alluxio.web.UIFileInfo;
import alluxio.web.WebUtils;
import alluxio.wire.BlockLocation;
import alluxio.wire.FileBlockInfo;
import alluxio.wire.FileInfo;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ThreadSafe
public final class WebInterfaceBrowseServlet
extends HttpServlet {
    private static final long serialVersionUID = 6121623049981468871L;
    private final transient AlluxioMaster mMaster;
    private final transient Configuration mConfiguration;

    public WebInterfaceBrowseServlet(AlluxioMaster master) {
        this.mMaster = master;
        this.mConfiguration = MasterContext.getConf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void displayFile(AlluxioURI path, HttpServletRequest request, long offset) throws FileDoesNotExistException, InvalidPathException, IOException, AlluxioException {
        FileSystem fs = FileSystem.Factory.get();
        String fileData = null;
        URIStatus status = fs.getStatus(path);
        if (status.isCompleted()) {
            OpenFileOptions options = OpenFileOptions.defaults().setReadType(ReadType.NO_CACHE);
            try (FileInStream is = fs.openFile(path, options);){
                int len = (int)Math.min(5120L, status.getLength() - offset);
                byte[] data = new byte[len];
                long skipped = is.skip(offset);
                if (skipped < 0L) {
                    fileData = "Unable to traverse to offset; is file empty?";
                }
                if (skipped < offset) {
                    fileData = "Unable to traverse to offset; is offset larger than the file?";
                }
                int read = is.read(data, 0, len);
                if (read < 0) {
                    fileData = "Unable to read file";
                }
                fileData = WebUtils.convertByteArrayToStringWithoutEscape(data, 0, read);
            }
        } else {
            fileData = "The requested file is not complete yet.";
        }
        ArrayList<UIFileBlockInfo> uiBlockInfo = new ArrayList<UIFileBlockInfo>();
        for (FileBlockInfo fileBlockInfo : this.mMaster.getFileSystemMaster().getFileBlockInfoList(path)) {
            uiBlockInfo.add(new UIFileBlockInfo(fileBlockInfo));
        }
        request.setAttribute("fileBlocks", uiBlockInfo);
        request.setAttribute("fileData", (Object)fileData);
        request.setAttribute("highestTierAlias", (Object)this.mMaster.getBlockMaster().getGlobalStorageTierAssoc().getAlias(0));
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        List<FileInfo> filesInfo;
        if (SecurityUtils.isSecurityEnabled((Configuration)this.mConfiguration) && PlainSaslServer.AuthorizedClientUser.get((Configuration)this.mConfiguration) == null) {
            PlainSaslServer.AuthorizedClientUser.set((String)LoginUser.get((Configuration)this.mConfiguration).getName());
        }
        request.setAttribute("debug", (Object)this.mConfiguration.getBoolean("alluxio.debug"));
        request.setAttribute("showPermissions", (Object)this.mConfiguration.getBoolean("alluxio.security.authorization.permission.enabled"));
        request.setAttribute("masterNodeAddress", (Object)this.mMaster.getMasterAddress().toString());
        request.setAttribute("invalidPathError", (Object)"");
        String requestPath = request.getParameter("path");
        if (requestPath == null || requestPath.isEmpty()) {
            requestPath = "/";
        }
        AlluxioURI currentPath = new AlluxioURI(requestPath);
        request.setAttribute("currentPath", (Object)currentPath.toString());
        request.setAttribute("viewingOffset", (Object)0);
        try {
            long fileId = this.mMaster.getFileSystemMaster().getFileId(currentPath);
            FileInfo fileInfo = this.mMaster.getFileSystemMaster().getFileInfo(fileId);
            UIFileInfo currentFileInfo = new UIFileInfo(fileInfo);
            if (currentFileInfo.getAbsolutePath() == null) {
                throw new FileDoesNotExistException(currentPath.toString());
            }
            request.setAttribute("currentDirectory", (Object)currentFileInfo);
            request.setAttribute("blockSizeBytes", (Object)currentFileInfo.getBlockSizeBytes());
            request.setAttribute("workerWebPort", (Object)this.mConfiguration.getInt("alluxio.worker.web.port"));
            if (!currentFileInfo.getIsDirectory()) {
                String offsetParam = request.getParameter("offset");
                long relativeOffset = 0L;
                try {
                    if (offsetParam != null) {
                        relativeOffset = Long.parseLong(offsetParam);
                    }
                }
                catch (NumberFormatException e) {
                    relativeOffset = 0L;
                }
                String endParam = request.getParameter("end");
                long offset = endParam == null ? relativeOffset : fileInfo.getLength() - relativeOffset;
                if (offset < 0L) {
                    offset = 0L;
                } else if (offset > fileInfo.getLength()) {
                    offset = fileInfo.getLength();
                }
                try {
                    this.displayFile(new AlluxioURI(currentFileInfo.getAbsolutePath()), request, offset);
                }
                catch (AlluxioException e) {
                    throw new IOException(e);
                }
                request.setAttribute("viewingOffset", (Object)offset);
                this.getServletContext().getRequestDispatcher("/viewFile.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            this.setPathDirectories(currentPath, request);
            filesInfo = this.mMaster.getFileSystemMaster().getFileInfoList(currentPath);
        }
        catch (FileDoesNotExistException e) {
            request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + e.getMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (InvalidPathException e) {
            request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + e.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (IOException e) {
            request.setAttribute("invalidPathError", (Object)("Error: File " + currentPath + " is not available " + e.getMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (AccessControlException e) {
            request.setAttribute("invalidPathError", (Object)("Error: File " + currentPath + " cannot be accessed " + e.getMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        ArrayList<UIFileInfo> fileInfos = new ArrayList<UIFileInfo>(filesInfo.size());
        for (FileInfo fileInfo : filesInfo) {
            UIFileInfo toAdd = new UIFileInfo(fileInfo);
            try {
                if (!toAdd.getIsDirectory() && fileInfo.getLength() > 0L) {
                    FileBlockInfo blockInfo = this.mMaster.getFileSystemMaster().getFileBlockInfoList(new AlluxioURI(toAdd.getAbsolutePath())).get(0);
                    ArrayList addrs = Lists.newArrayList();
                    for (BlockLocation location : blockInfo.getBlockInfo().getLocations()) {
                        addrs.add(location.getWorkerAddress());
                    }
                    addrs.addAll(blockInfo.getUfsLocations());
                    toAdd.setFileLocations(addrs);
                }
            }
            catch (FileDoesNotExistException e) {
                request.setAttribute("FileDoesNotExistException", (Object)("Error: non-existing file " + e.getMessage()));
                this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            catch (InvalidPathException e) {
                request.setAttribute("InvalidPathException", (Object)("Error: invalid path " + e.getMessage()));
                this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            }
            fileInfos.add(toAdd);
        }
        Collections.sort(fileInfos, UIFileInfo.PATH_STRING_COMPARE);
        request.setAttribute("nTotalFile", (Object)fileInfos.size());
        if (request.getParameter("offset") == null && request.getParameter("limit") == null) {
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            int offset = Integer.parseInt(request.getParameter("offset"));
            int limit = Integer.parseInt(request.getParameter("limit"));
            List sub = fileInfos.subList(offset, offset + limit);
            request.setAttribute("fileInfos", sub);
        }
        catch (NumberFormatException e) {
            request.setAttribute("fatalError", (Object)("Error: offset or limit parse error, " + e.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            request.setAttribute("fatalError", (Object)("Error: offset or offset + limit is out of bound, " + e.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (IllegalArgumentException e) {
            request.setAttribute("fatalError", (Object)e.getLocalizedMessage());
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void setPathDirectories(AlluxioURI path, HttpServletRequest request) throws FileDoesNotExistException, InvalidPathException, AccessControlException {
        if (path.isRoot()) {
            request.setAttribute("pathInfos", (Object)new UIFileInfo[0]);
            return;
        }
        String[] splitPath = PathUtils.getPathComponents((String)path.toString());
        UIFileInfo[] pathInfos = new UIFileInfo[splitPath.length - 1];
        AlluxioURI currentPath = new AlluxioURI("/");
        long fileId = this.mMaster.getFileSystemMaster().getFileId(currentPath);
        pathInfos[0] = new UIFileInfo(this.mMaster.getFileSystemMaster().getFileInfo(fileId));
        for (int i = 1; i < splitPath.length - 1; ++i) {
            currentPath = currentPath.join(splitPath[i]);
            fileId = this.mMaster.getFileSystemMaster().getFileId(currentPath);
            pathInfos[i] = new UIFileInfo(this.mMaster.getFileSystemMaster().getFileInfo(fileId));
        }
        request.setAttribute("pathInfos", (Object)pathInfos);
    }
}

