/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.Configuration;
import alluxio.master.file.FileSystemMaster;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@ThreadSafe
public final class WebInterfaceConfigurationServlet
extends HttpServlet {
    private static final long serialVersionUID = 2134205675393443914L;
    private static final String ALLUXIO_CONF_PREFIX = "alluxio";
    private static final Set<String> ALLUXIO_CONF_EXCLUDES = new HashSet<String>(Arrays.asList("alluxio.master.whitelist"));
    private final transient FileSystemMaster mFsMaster;
    private final transient Configuration mConfiguration;

    public WebInterfaceConfigurationServlet(FileSystemMaster fsMaster) {
        this.mFsMaster = fsMaster;
        this.mConfiguration = new Configuration();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("whitelist", this.mFsMaster.getWhiteList());
        request.setAttribute("configuration", this.getSortedProperties());
        this.getServletContext().getRequestDispatcher("/configuration.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private SortedSet<Pair<String, String>> getSortedProperties() {
        TreeSet<Pair<String, String>> rtn = new TreeSet<Pair<String, String>>();
        for (Map.Entry<Object, Object> entry : this.mConfiguration.getInternalProperties().entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(ALLUXIO_CONF_PREFIX) || ALLUXIO_CONF_EXCLUDES.contains(key)) continue;
            rtn.add((Pair<String, String>)new ImmutablePair((Object)key, (Object)this.mConfiguration.get(key)));
        }
        return rtn;
    }
}

