/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.Configuration;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ThreadSafe
public final class WebInterfaceDownloadLocalServlet
extends HttpServlet {
    private static final long serialVersionUID = 7260819317567193560L;
    private final transient Configuration mConfiguration = new Configuration();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestPath = request.getParameter("path");
        if (requestPath == null || requestPath.isEmpty()) {
            requestPath = "/";
        }
        File logsDir = new File(this.mConfiguration.get("alluxio.logs.dir"));
        requestPath = new File(requestPath).getName();
        File logFile = new File(logsDir, requestPath);
        try {
            this.downloadLogFile(logFile, request, response);
        }
        catch (FileNotFoundException e) {
            request.setAttribute("invalidPathError", (Object)("Error: Invalid file " + e.getMessage()));
            request.setAttribute("currentPath", (Object)requestPath);
            request.setAttribute("downloadLogFile", (Object)1);
            request.setAttribute("viewingOffset", (Object)0);
            request.setAttribute("baseUrl", (Object)"./browseLogs");
            this.getServletContext().getRequestDispatcher("/viewFile.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadLogFile(File file, HttpServletRequest request, HttpServletResponse response) throws IOException {
        long len = file.length();
        String fileName = file.getName();
        response.setContentType("application/octet-stream");
        if (len <= Integer.MAX_VALUE) {
            response.setContentLength((int)len);
        } else {
            response.addHeader("Content-Length", Long.toString(len));
        }
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        try (FileInputStream is = new FileInputStream(file);){
            ServletOutputStream out = response.getOutputStream();
            try {
                ByteStreams.copy((InputStream)is, (OutputStream)out);
            }
            finally {
                try {
                    out.flush();
                }
                finally {
                    out.close();
                }
            }
        }
    }
}

