/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.client.ReadType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.URIStatus;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.master.MasterContext;
import alluxio.master.file.FileSystemMaster;
import alluxio.security.LoginUser;
import alluxio.security.authentication.PlainSaslServer;
import alluxio.util.SecurityUtils;
import alluxio.wire.FileInfo;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ThreadSafe
public final class WebInterfaceDownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 7329267100965731815L;
    private final transient FileSystemMaster mFsMaster;

    public WebInterfaceDownloadServlet(FileSystemMaster fsMaster) {
        this.mFsMaster = (FileSystemMaster)Preconditions.checkNotNull((Object)fsMaster);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String requestPath;
        if (SecurityUtils.isSecurityEnabled((Configuration)MasterContext.getConf()) && PlainSaslServer.AuthorizedClientUser.get((Configuration)MasterContext.getConf()) == null) {
            PlainSaslServer.AuthorizedClientUser.set((String)LoginUser.get((Configuration)MasterContext.getConf()).getName());
        }
        if ((requestPath = request.getParameter("path")) == null || requestPath.isEmpty()) {
            requestPath = "/";
        }
        AlluxioURI currentPath = new AlluxioURI(requestPath);
        try {
            long fileId = this.mFsMaster.getFileId(currentPath);
            FileInfo fileInfo = this.mFsMaster.getFileInfo(fileId);
            if (fileInfo == null) {
                throw new FileDoesNotExistException(currentPath.toString());
            }
            this.downloadFile(new AlluxioURI(fileInfo.getPath()), request, response);
        }
        catch (FileDoesNotExistException e) {
            request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + e.getMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (InvalidPathException e) {
            request.setAttribute("invalidPathError", (Object)("Error: Invalid Path " + e.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
        catch (AlluxioException e) {
            request.setAttribute("invalidPathError", (Object)("Error: " + e.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/browse.jsp").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadFile(AlluxioURI path, HttpServletRequest request, HttpServletResponse response) throws FileDoesNotExistException, IOException, InvalidPathException, AlluxioException {
        FileSystem alluxioClient = FileSystem.Factory.get();
        URIStatus status = alluxioClient.getStatus(path);
        long len = status.getLength();
        String fileName = path.getName();
        response.setContentType("application/octet-stream");
        if (len <= Integer.MAX_VALUE) {
            response.setContentLength((int)len);
        } else {
            response.addHeader("Content-Length", Long.toString(len));
        }
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        FileInStream is = null;
        ServletOutputStream out = null;
        try {
            OpenFileOptions options = OpenFileOptions.defaults().setReadType(ReadType.NO_CACHE);
            is = alluxioClient.openFile(path, options);
            out = response.getOutputStream();
            ByteStreams.copy((InputStream)is, (OutputStream)out);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }
}

