/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.Configuration;
import alluxio.StorageTierAssoc;
import alluxio.Version;
import alluxio.master.AlluxioMaster;
import alluxio.master.MasterContext;
import alluxio.underfs.UnderFileSystem;
import alluxio.util.FormatUtils;
import alluxio.web.WebUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ThreadSafe
public final class WebInterfaceGeneralServlet
extends HttpServlet {
    private static final long serialVersionUID = 2335205655766736309L;
    private final transient AlluxioMaster mMaster;
    private final transient Configuration mConfiguration;

    public WebInterfaceGeneralServlet(AlluxioMaster master) {
        this.mMaster = master;
        this.mConfiguration = MasterContext.getConf();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.populateValues(request);
        this.getServletContext().getRequestDispatcher("/general.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.populateValues(request);
        this.getServletContext().getRequestDispatcher("/general.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private StorageTierInfo[] generateOrderedStorageTierInfo() {
        StorageTierAssoc globalStorageTierAssoc = this.mMaster.getBlockMaster().getGlobalStorageTierAssoc();
        ArrayList<StorageTierInfo> infos = new ArrayList<StorageTierInfo>();
        Map<String, Long> totalBytesOnTiers = this.mMaster.getBlockMaster().getTotalBytesOnTiers();
        Map<String, Long> usedBytesOnTiers = this.mMaster.getBlockMaster().getUsedBytesOnTiers();
        for (int ordinal = 0; ordinal < globalStorageTierAssoc.size(); ++ordinal) {
            String tierAlias = globalStorageTierAssoc.getAlias(ordinal);
            if (!totalBytesOnTiers.containsKey(tierAlias) || totalBytesOnTiers.get(tierAlias) <= 0L) continue;
            StorageTierInfo info = new StorageTierInfo(tierAlias, totalBytesOnTiers.get(tierAlias), usedBytesOnTiers.get(tierAlias));
            infos.add(info);
        }
        StorageTierInfo[] ret = infos.toArray(new StorageTierInfo[infos.size()]);
        return ret;
    }

    private void populateValues(HttpServletRequest request) throws IOException {
        request.setAttribute("debug", (Object)this.mConfiguration.getBoolean("alluxio.debug"));
        request.setAttribute("masterNodeAddress", (Object)this.mMaster.getMasterAddress().toString());
        request.setAttribute("uptime", (Object)WebUtils.convertMsToClockTime(System.currentTimeMillis() - this.mMaster.getStarttimeMs()));
        request.setAttribute("startTime", (Object)WebUtils.convertMsToDate(this.mMaster.getStarttimeMs()));
        request.setAttribute("version", (Object)Version.VERSION);
        request.setAttribute("liveWorkerNodes", (Object)Integer.toString(this.mMaster.getBlockMaster().getWorkerCount()));
        request.setAttribute("capacity", (Object)FormatUtils.getSizeFromBytes((long)this.mMaster.getBlockMaster().getCapacityBytes()));
        request.setAttribute("usedCapacity", (Object)FormatUtils.getSizeFromBytes((long)this.mMaster.getBlockMaster().getUsedBytes()));
        request.setAttribute("freeCapacity", (Object)FormatUtils.getSizeFromBytes((long)(this.mMaster.getBlockMaster().getCapacityBytes() - this.mMaster.getBlockMaster().getUsedBytes())));
        Configuration conf = new Configuration();
        String ufsRoot = conf.get("alluxio.underfs.address");
        UnderFileSystem ufs = UnderFileSystem.get((String)ufsRoot, (Configuration)conf);
        long sizeBytes = ufs.getSpace(ufsRoot, UnderFileSystem.SpaceType.SPACE_TOTAL);
        if (sizeBytes >= 0L) {
            request.setAttribute("diskCapacity", (Object)FormatUtils.getSizeFromBytes((long)sizeBytes));
        } else {
            request.setAttribute("diskCapacity", (Object)"UNKNOWN");
        }
        sizeBytes = ufs.getSpace(ufsRoot, UnderFileSystem.SpaceType.SPACE_USED);
        if (sizeBytes >= 0L) {
            request.setAttribute("diskUsedCapacity", (Object)FormatUtils.getSizeFromBytes((long)sizeBytes));
        } else {
            request.setAttribute("diskUsedCapacity", (Object)"UNKNOWN");
        }
        sizeBytes = ufs.getSpace(ufsRoot, UnderFileSystem.SpaceType.SPACE_FREE);
        if (sizeBytes >= 0L) {
            request.setAttribute("diskFreeCapacity", (Object)FormatUtils.getSizeFromBytes((long)sizeBytes));
        } else {
            request.setAttribute("diskFreeCapacity", (Object)"UNKNOWN");
        }
        StorageTierInfo[] infos = this.generateOrderedStorageTierInfo();
        request.setAttribute("storageTierInfos", (Object)infos);
    }

    public static final class StorageTierInfo {
        private final String mStorageTierAlias;
        private final long mCapacityBytes;
        private final long mUsedBytes;
        private final int mUsedPercent;
        private final long mFreeBytes;
        private final int mFreePercent;

        private StorageTierInfo(String storageTierAlias, long capacityBytes, long usedBytes) {
            this.mStorageTierAlias = storageTierAlias;
            this.mCapacityBytes = capacityBytes;
            this.mUsedBytes = usedBytes;
            this.mFreeBytes = this.mCapacityBytes - this.mUsedBytes;
            this.mUsedPercent = (int)(100L * this.mUsedBytes / this.mCapacityBytes);
            this.mFreePercent = 100 - this.mUsedPercent;
        }

        public String getStorageTierAlias() {
            return this.mStorageTierAlias;
        }

        public String getCapacity() {
            return FormatUtils.getSizeFromBytes((long)this.mCapacityBytes);
        }

        public String getFreeCapacity() {
            return FormatUtils.getSizeFromBytes((long)this.mFreeBytes);
        }

        public int getFreeSpacePercent() {
            return this.mFreePercent;
        }

        public String getUsedCapacity() {
            return FormatUtils.getSizeFromBytes((long)this.mUsedBytes);
        }

        public int getUsedSpacePercent() {
            return this.mUsedPercent;
        }
    }
}

