/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.Configuration;
import alluxio.util.network.NetworkAddressUtils;
import java.io.IOException;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ThreadSafe
public final class WebInterfaceHeaderServlet
extends HttpServlet {
    private static final long serialVersionUID = -2466055439220042703L;
    private final transient Configuration mConfiguration;

    public WebInterfaceHeaderServlet(Configuration conf) {
        this.mConfiguration = conf;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int masterWebPort = this.mConfiguration.getInt("alluxio.master.web.port");
        String masterHostName = NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.MASTER_RPC, (Configuration)this.mConfiguration);
        request.setAttribute("masterHost", (Object)masterHostName);
        request.setAttribute("masterPort", (Object)masterWebPort);
        this.getServletContext().getRequestDispatcher("/header.jsp").include((ServletRequest)request, (ServletResponse)response);
    }
}

