/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.exception.AccessControlException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.master.AlluxioMaster;
import alluxio.master.MasterContext;
import alluxio.security.LoginUser;
import alluxio.security.authentication.PlainSaslServer;
import alluxio.util.SecurityUtils;
import alluxio.web.UIFileInfo;
import alluxio.wire.FileInfo;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ThreadSafe
public final class WebInterfaceMemoryServlet
extends HttpServlet {
    private static final long serialVersionUID = 4293149962399443914L;
    private final transient AlluxioMaster mMaster;

    public WebInterfaceMemoryServlet(AlluxioMaster master) {
        this.mMaster = (AlluxioMaster)Preconditions.checkNotNull((Object)master);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (SecurityUtils.isSecurityEnabled((Configuration)MasterContext.getConf()) && PlainSaslServer.AuthorizedClientUser.get((Configuration)MasterContext.getConf()) == null) {
            PlainSaslServer.AuthorizedClientUser.set((String)LoginUser.get((Configuration)MasterContext.getConf()).getName());
        }
        request.setAttribute("masterNodeAddress", (Object)this.mMaster.getMasterAddress().toString());
        request.setAttribute("fatalError", (Object)"");
        List<AlluxioURI> inMemoryFiles = this.mMaster.getFileSystemMaster().getInMemoryFiles();
        Collections.sort(inMemoryFiles);
        ArrayList<UIFileInfo> fileInfos = new ArrayList<UIFileInfo>(inMemoryFiles.size());
        for (AlluxioURI file : inMemoryFiles) {
            try {
                long fileId = this.mMaster.getFileSystemMaster().getFileId(file);
                FileInfo fileInfo = this.mMaster.getFileSystemMaster().getFileInfo(fileId);
                if (fileInfo == null || fileInfo.getInMemoryPercentage() != 100) continue;
                fileInfos.add(new UIFileInfo(fileInfo));
            }
            catch (FileDoesNotExistException e) {
                request.setAttribute("fatalError", (Object)("Error: File does not exist " + e.getLocalizedMessage()));
                this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            catch (AccessControlException e) {
                request.setAttribute("permissionError", (Object)("Error: File " + file + " cannot be accessed " + e.getMessage()));
                this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        request.setAttribute("inMemoryFileNum", (Object)fileInfos.size());
        if (request.getParameter("offset") == null && request.getParameter("limit") == null) {
            this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            int offset = Integer.parseInt(request.getParameter("offset"));
            int limit = Integer.parseInt(request.getParameter("limit"));
            List sub = fileInfos.subList(offset, offset + limit);
            request.setAttribute("fileInfos", sub);
        }
        catch (NumberFormatException e) {
            request.setAttribute("fatalError", (Object)("Error: offset or limit parse error, " + e.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            request.setAttribute("fatalError", (Object)("Error: offset or offset + limit is out of bound, " + e.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (IllegalArgumentException e) {
            request.setAttribute("fatalError", (Object)e.getLocalizedMessage());
            this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.getServletContext().getRequestDispatcher("/memory.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

