/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.AlluxioURI;
import alluxio.WorkerStorageTierAssoc;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.FileSystemMasterClient;
import alluxio.client.file.URIStatus;
import alluxio.exception.AlluxioException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.FileDoesNotExistException;
import alluxio.exception.InvalidPathException;
import alluxio.master.block.BlockId;
import alluxio.web.UIFileInfo;
import alluxio.worker.WorkerContext;
import alluxio.worker.block.BlockStoreMeta;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.block.meta.BlockMeta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ThreadSafe
public final class WebInterfaceWorkerBlockInfoServlet
extends HttpServlet {
    private static final long serialVersionUID = 4148506607369321012L;
    private final transient BlockWorker mBlockWorker;

    public WebInterfaceWorkerBlockInfoServlet(BlockWorker blockWorker) {
        this.mBlockWorker = (BlockWorker)Preconditions.checkNotNull((Object)blockWorker);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("fatalError", (Object)"");
        FileSystem fs = FileSystem.Factory.get();
        String filePath = request.getParameter("path");
        if (filePath != null && !filePath.isEmpty()) {
            try {
                UIFileInfo uiFileInfo = this.getUiFileInfo(fs, new AlluxioURI(filePath));
                request.setAttribute("fileBlocksOnTier", uiFileInfo.getBlocksOnTier());
                request.setAttribute("blockSizeBytes", (Object)uiFileInfo.getBlockSizeBytes());
                request.setAttribute("path", (Object)filePath);
                this.getServletContext().getRequestDispatcher("/worker/viewFileBlocks.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            catch (FileDoesNotExistException e) {
                request.setAttribute("fatalError", (Object)("Error: Invalid Path " + e.getMessage()));
                this.getServletContext().getRequestDispatcher("/worker/blockInfo.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            catch (IOException e) {
                request.setAttribute("invalidPathError", (Object)("Error: File " + filePath + " is not available " + e.getMessage()));
                this.getServletContext().getRequestDispatcher("/worker/blockInfo.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            catch (BlockDoesNotExistException e) {
                request.setAttribute("fatalError", (Object)("Error: block not found. " + e.getMessage()));
                this.getServletContext().getRequestDispatcher("/worker/blockInfo.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            catch (AlluxioException e) {
                request.setAttribute("fatalError", (Object)("Error: alluxio exception. " + e.getMessage()));
                this.getServletContext().getRequestDispatcher("/worker/blockInfo.jsp").forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
        }
        List<Long> fileIds = this.getSortedFileIds();
        request.setAttribute("nTotalFile", (Object)fileIds.size());
        request.setAttribute("orderedTierAliases", new WorkerStorageTierAssoc(WorkerContext.getConf()).getOrderedStorageAliases());
        if (request.getParameter("offset") == null && request.getParameter("limit") == null) {
            this.getServletContext().getRequestDispatcher("/worker/blockInfo.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            int offset = Integer.parseInt(request.getParameter("offset"));
            int limit = Integer.parseInt(request.getParameter("limit"));
            List<Long> subFileIds = fileIds.subList(offset, offset + limit);
            ArrayList<UIFileInfo> uiFileInfos = new ArrayList<UIFileInfo>(subFileIds.size());
            for (long fileId : subFileIds) {
                uiFileInfos.add(this.getUiFileInfo(fs, fileId));
            }
            request.setAttribute("fileInfos", uiFileInfos);
        }
        catch (FileDoesNotExistException e) {
            request.setAttribute("fatalError", (Object)("Error: Invalid FileId " + e.getMessage()));
            this.getServletContext().getRequestDispatcher("/worker/blockInfo.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (NumberFormatException e) {
            request.setAttribute("fatalError", (Object)("Error: offset or limit parse error, " + e.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/worker/blockInfo.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            request.setAttribute("fatalError", (Object)("Error: offset or offset + limit is out of bound, " + e.getLocalizedMessage()));
            this.getServletContext().getRequestDispatcher("/worker/blockInfo.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (IllegalArgumentException e) {
            request.setAttribute("fatalError", (Object)e.getLocalizedMessage());
            this.getServletContext().getRequestDispatcher("/worker/blockInfo.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (BlockDoesNotExistException e) {
            request.setAttribute("fatalError", (Object)e.getLocalizedMessage());
            this.getServletContext().getRequestDispatcher("/worker/blockInfo.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        catch (AlluxioException e) {
            request.setAttribute("fatalError", (Object)e.getLocalizedMessage());
            this.getServletContext().getRequestDispatcher("/worker/blockInfo.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.getServletContext().getRequestDispatcher("/worker/blockInfo.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private List<Long> getSortedFileIds() {
        HashSet<Long> fileIds = new HashSet<Long>();
        BlockStoreMeta storeMeta = this.mBlockWorker.getStoreMeta();
        for (List<Long> blockIds : storeMeta.getBlockList().values()) {
            for (long blockId : blockIds) {
                long fileId = BlockId.createBlockId((long)BlockId.getContainerId((long)blockId), (long)BlockId.getMaxSequenceNumber());
                fileIds.add(fileId);
            }
        }
        ArrayList<Long> sortedFileIds = new ArrayList<Long>(fileIds);
        Collections.sort(sortedFileIds);
        return sortedFileIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UIFileInfo getUiFileInfo(FileSystem fileSystem, long fileId) throws FileDoesNotExistException, BlockDoesNotExistException, IOException, AlluxioException {
        FileSystemMasterClient masterClient = FileSystemContext.INSTANCE.acquireMasterClient();
        try {
            UIFileInfo uIFileInfo = this.getUiFileInfo(fileSystem, new AlluxioURI(masterClient.getStatusInternal(fileId).getPath()));
            return uIFileInfo;
        }
        finally {
            FileSystemContext.INSTANCE.releaseMasterClient(masterClient);
        }
    }

    private UIFileInfo getUiFileInfo(FileSystem fileSystem, AlluxioURI filePath) throws BlockDoesNotExistException, FileDoesNotExistException, InvalidPathException, IOException, AlluxioException {
        URIStatus status;
        try {
            status = fileSystem.getStatus(filePath);
        }
        catch (AlluxioException e) {
            throw new FileDoesNotExistException(filePath.toString());
        }
        UIFileInfo uiFileInfo = new UIFileInfo(status);
        boolean blockExistOnWorker = false;
        Iterator i$ = status.getBlockIds().iterator();
        while (i$.hasNext()) {
            long blockId = (Long)i$.next();
            if (!this.mBlockWorker.hasBlockMeta(blockId)) continue;
            blockExistOnWorker = true;
            BlockMeta blockMeta = this.mBlockWorker.getVolatileBlockMeta(blockId);
            long blockSize = blockMeta.getBlockSize();
            uiFileInfo.addBlock(blockMeta.getBlockLocation().tierAlias(), blockId, blockSize, -1L);
        }
        if (!blockExistOnWorker) {
            throw new FileDoesNotExistException(filePath.toString());
        }
        return uiFileInfo;
    }
}

