/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.Version;
import alluxio.collections.Pair;
import alluxio.util.FormatUtils;
import alluxio.web.WebUtils;
import alluxio.worker.WorkerContext;
import alluxio.worker.block.BlockStoreMeta;
import alluxio.worker.block.BlockWorker;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ThreadSafe
public final class WebInterfaceWorkerGeneralServlet
extends HttpServlet {
    private static final long serialVersionUID = 3735143768058466487L;
    private final transient BlockWorker mBlockWorker;
    private final UIWorkerInfo mUiWorkerInfo;

    public WebInterfaceWorkerGeneralServlet(BlockWorker blockWorker, InetSocketAddress workerAddress, long startTimeMs) {
        this.mBlockWorker = blockWorker;
        this.mUiWorkerInfo = new UIWorkerInfo(workerAddress.toString(), startTimeMs);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.populateValues(request);
        this.getServletContext().getRequestDispatcher("/worker/general.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private void populateValues(HttpServletRequest request) throws IOException {
        request.setAttribute("workerInfo", (Object)this.mUiWorkerInfo);
        BlockStoreMeta storeMeta = this.mBlockWorker.getStoreMeta();
        long capacityBytes = 0L;
        long usedBytes = 0L;
        Map<String, Long> capacityBytesOnTiers = storeMeta.getCapacityBytesOnTiers();
        Map<String, Long> usedBytesOnTiers = storeMeta.getUsedBytesOnTiers();
        for (long capacity : capacityBytesOnTiers.values()) {
            capacityBytes += capacity;
        }
        for (long used : usedBytesOnTiers.values()) {
            usedBytes += used;
        }
        request.setAttribute("capacityBytes", (Object)FormatUtils.getSizeFromBytes((long)capacityBytes));
        request.setAttribute("usedBytes", (Object)FormatUtils.getSizeFromBytes((long)usedBytes));
        request.setAttribute("capacityBytesOnTiers", capacityBytesOnTiers);
        request.setAttribute("usedBytesOnTiers", usedBytesOnTiers);
        ArrayList<UIStorageDir> storageDirs = new ArrayList<UIStorageDir>(storeMeta.getCapacityBytesOnDirs().size());
        for (Pair<String, String> tierAndDirPath : storeMeta.getCapacityBytesOnDirs().keySet()) {
            storageDirs.add(new UIStorageDir((String)tierAndDirPath.getFirst(), (String)tierAndDirPath.getSecond(), storeMeta.getCapacityBytesOnDirs().get(tierAndDirPath), storeMeta.getUsedBytesOnDirs().get(tierAndDirPath)));
        }
        request.setAttribute("storageDirs", storageDirs);
    }

    public static class UIWorkerInfo {
        public static final boolean DEBUG = WorkerContext.getConf().getBoolean("alluxio.debug");
        public static final String VERSION = Version.VERSION;
        private final String mWorkerAddress;
        private final long mStartTimeMs;

        public UIWorkerInfo(String workerAddress, long startTimeMs) {
            this.mWorkerAddress = workerAddress;
            this.mStartTimeMs = startTimeMs;
        }

        public String getStartTime() {
            return WebUtils.convertMsToDate(this.mStartTimeMs);
        }

        public String getUptime() {
            return WebUtils.convertMsToClockTime(System.currentTimeMillis() - this.mStartTimeMs);
        }

        public String getWorkerAddress() {
            return this.mWorkerAddress;
        }
    }

    public static class UIStorageDir {
        private final String mTierAlias;
        private final String mDirPath;
        private final long mCapacityBytes;
        private final long mUsedBytes;

        public UIStorageDir(String tierAlias, String dirPath, long capacityBytes, long usedBytes) {
            this.mTierAlias = tierAlias;
            this.mDirPath = dirPath;
            this.mCapacityBytes = capacityBytes;
            this.mUsedBytes = usedBytes;
        }

        public long getCapacityBytes() {
            return this.mCapacityBytes;
        }

        public String getDirPath() {
            return this.mDirPath;
        }

        public String getTierAlias() {
            return this.mTierAlias;
        }

        public long getUsedBytes() {
            return this.mUsedBytes;
        }
    }
}

