/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.Configuration;
import alluxio.master.block.BlockMaster;
import alluxio.util.FormatUtils;
import alluxio.web.WebUtils;
import alluxio.wire.WorkerInfo;
import alluxio.worker.WorkerContext;
import com.google.common.base.Objects;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ThreadSafe
public final class WebInterfaceWorkersServlet
extends HttpServlet {
    private static final long serialVersionUID = -7454493761603179826L;
    private final transient BlockMaster mBlockMaster;
    private final transient Configuration mConfiguration;

    public WebInterfaceWorkersServlet(BlockMaster blockMaster) {
        this.mBlockMaster = blockMaster;
        this.mConfiguration = WorkerContext.getConf();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.populateValues(request);
        this.getServletContext().getRequestDispatcher("/workers.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private NodeInfo[] generateOrderedNodeInfos(Collection<WorkerInfo> workerInfos) {
        Object[] ret = new NodeInfo[workerInfos.size()];
        int index = 0;
        for (WorkerInfo workerInfo : workerInfos) {
            ret[index++] = new NodeInfo(workerInfo);
        }
        Arrays.sort(ret);
        return ret;
    }

    private void populateValues(HttpServletRequest request) throws IOException {
        request.setAttribute("debug", (Object)this.mConfiguration.getBoolean("alluxio.debug"));
        List<WorkerInfo> workerInfos = this.mBlockMaster.getWorkerInfoList();
        NodeInfo[] normalNodeInfos = this.generateOrderedNodeInfos(workerInfos);
        request.setAttribute("normalNodeInfos", (Object)normalNodeInfos);
        Set<WorkerInfo> lostWorkerInfos = this.mBlockMaster.getLostWorkersInfo();
        NodeInfo[] failedNodeInfos = this.generateOrderedNodeInfos(lostWorkerInfos);
        request.setAttribute("failedNodeInfos", (Object)failedNodeInfos);
        request.setAttribute("workerWebPort", (Object)this.mConfiguration.getInt("alluxio.worker.web.port"));
    }

    public static final class NodeInfo
    implements Comparable<NodeInfo> {
        private final String mHost;
        private final int mWebPort;
        private final String mLastContactSec;
        private final String mWorkerState;
        private final long mCapacityBytes;
        private final long mUsedBytes;
        private final int mFreePercent;
        private final int mUsedPercent;
        private final String mUptimeClockTime;

        private NodeInfo(WorkerInfo workerInfo) {
            this.mHost = workerInfo.getAddress().getHost();
            this.mWebPort = workerInfo.getAddress().getWebPort();
            this.mLastContactSec = Integer.toString(workerInfo.getLastContactSec());
            this.mWorkerState = workerInfo.getState();
            this.mCapacityBytes = workerInfo.getCapacityBytes();
            this.mUsedBytes = workerInfo.getUsedBytes();
            this.mUsedPercent = this.mCapacityBytes != 0L ? (int)(100L * this.mUsedBytes / this.mCapacityBytes) : 0;
            this.mFreePercent = 100 - this.mUsedPercent;
            this.mUptimeClockTime = WebUtils.convertMsToShortClockTime(System.currentTimeMillis() - workerInfo.getStartTimeMs());
        }

        public String getCapacity() {
            return FormatUtils.getSizeFromBytes((long)this.mCapacityBytes);
        }

        public int getFreeSpacePercent() {
            return this.mFreePercent;
        }

        public String getLastHeartbeat() {
            return this.mLastContactSec;
        }

        public String getHost() {
            return this.mHost;
        }

        public int getWebPort() {
            return this.mWebPort;
        }

        public String getState() {
            return this.mWorkerState;
        }

        public String getUptimeClockTime() {
            return this.mUptimeClockTime;
        }

        public String getUsedMemory() {
            return FormatUtils.getSizeFromBytes((long)this.mUsedBytes);
        }

        public int getUsedSpacePercent() {
            return this.mUsedPercent;
        }

        @Override
        public int compareTo(NodeInfo o) {
            if (o == null) {
                return 1;
            }
            return this.getHost().compareTo(o.getHost());
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NodeInfo)) {
                return false;
            }
            return this.getHost().equals(((NodeInfo)o).getHost());
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getHost()});
        }
    }
}

