/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import com.google.common.base.Preconditions;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class WebUtils {
    public static String convertByteArrayToStringWithoutEscape(byte[] data, int offset, int length) {
        StringBuilder sb = new StringBuilder(length);
        for (int i = offset; i < length && i < data.length; ++i) {
            sb.append((char)data[i]);
        }
        return sb.toString();
    }

    public static String convertMsToClockTime(long millis) {
        Preconditions.checkArgument((millis >= 0L ? 1 : 0) != 0, (Object)"Negative values are not supported");
        long days = millis / 86400000L;
        long hours = millis % 86400000L / 3600000L;
        long mins = millis % 3600000L / 60000L;
        long secs = millis % 60000L / 1000L;
        return String.format("%d day(s), %d hour(s), %d minute(s), and %d second(s)", days, hours, mins, secs);
    }

    public static String convertMsToDate(long millis) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss:SSS");
        return formatter.format(new Date(millis));
    }

    public static String convertMsToShortClockTime(long millis) {
        Preconditions.checkArgument((millis >= 0L ? 1 : 0) != 0, (Object)"Negative values are not supported");
        long days = millis / 86400000L;
        long hours = millis % 86400000L / 3600000L;
        long mins = millis % 3600000L / 60000L;
        long secs = millis % 60000L / 1000L;
        return String.format("%d d, %d h, %d m, and %d s", days, hours, mins, secs);
    }

    private WebUtils() {
    }
}

