/*
 * Decompiled with CFR 0.152.
 */
package alluxio.web;

import alluxio.Configuration;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.web.UIWebServer;
import alluxio.web.WebInterfaceBrowseLogsServlet;
import alluxio.web.WebInterfaceDownloadLocalServlet;
import alluxio.web.WebInterfaceHeaderServlet;
import alluxio.web.WebInterfaceWorkerBlockInfoServlet;
import alluxio.web.WebInterfaceWorkerGeneralServlet;
import alluxio.worker.block.BlockWorker;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.NotThreadSafe;
import javax.servlet.Servlet;
import org.eclipse.jetty.servlet.ServletHolder;

@NotThreadSafe
public final class WorkerUIWebServer
extends UIWebServer {
    public WorkerUIWebServer(NetworkAddressUtils.ServiceType serviceType, InetSocketAddress webAddress, BlockWorker blockWorker, InetSocketAddress workerAddress, long startTimeMs, Configuration conf) {
        super(serviceType, webAddress, conf);
        Preconditions.checkNotNull((Object)blockWorker, (Object)"Block Worker cannot be null");
        Preconditions.checkNotNull((Object)workerAddress, (Object)"Worker address cannot be null");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceWorkerGeneralServlet(blockWorker, workerAddress, startTimeMs)), "/home");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceWorkerBlockInfoServlet(blockWorker)), "/blockInfo");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceDownloadLocalServlet()), "/downloadLocal");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceBrowseLogsServlet(false)), "/browseLogs");
        this.mWebAppContext.addServlet(new ServletHolder((Servlet)new WebInterfaceHeaderServlet(conf)), "/header");
    }
}

