/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker;

import alluxio.Configuration;
import alluxio.Version;
import alluxio.metrics.MetricsSystem;
import alluxio.security.authentication.AuthenticationUtils;
import alluxio.util.network.NetworkAddressUtils;
import alluxio.web.UIWebServer;
import alluxio.web.WorkerUIWebServer;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.AbstractWorker;
import alluxio.worker.Worker;
import alluxio.worker.WorkerContext;
import alluxio.worker.WorkerFactory;
import alluxio.worker.WorkerIdRegistry;
import alluxio.worker.WorkerSource;
import alluxio.worker.block.BlockWorker;
import alluxio.worker.block.BlockWorkerClientServiceHandler;
import alluxio.worker.file.FileSystemWorker;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportException;
import org.apache.thrift.transport.TTransportFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class AlluxioWorker {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private Configuration mConfiguration;
    private BlockWorker mBlockWorker;
    private FileSystemWorker mFileSystemWorker;
    private List<Worker> mAdditionalWorkers;
    private boolean mIsServingRPC = false;
    private MetricsSystem mWorkerMetricsSystem;
    private UIWebServer mWebServer;
    private TThreadPoolServer mThriftServer;
    private TServerSocket mThriftServerSocket;
    private int mRPCPort;
    private InetSocketAddress mWorkerAddress;
    private WorkerNetAddress mNetAddress;
    private long mStartTimeMs;

    public AlluxioWorker() {
        try {
            this.mStartTimeMs = System.currentTimeMillis();
            this.mConfiguration = WorkerContext.getConf();
            this.mBlockWorker = new BlockWorker();
            this.mFileSystemWorker = new FileSystemWorker(this.mBlockWorker);
            this.mAdditionalWorkers = Lists.newArrayList();
            ArrayList workers = Lists.newArrayList((Object[])new AbstractWorker[]{this.mBlockWorker, this.mFileSystemWorker});
            ServiceLoader<WorkerFactory> discoveredMasterFactories = ServiceLoader.load(WorkerFactory.class, WorkerFactory.class.getClassLoader());
            for (WorkerFactory factory : discoveredMasterFactories) {
                Worker worker = factory.create(workers);
                if (worker == null) continue;
                this.mAdditionalWorkers.add(worker);
            }
            this.mWorkerMetricsSystem = new MetricsSystem("worker", this.mConfiguration);
            WorkerSource workerSource = WorkerContext.getWorkerSource();
            workerSource.registerGauges(this.mBlockWorker);
            this.mWorkerMetricsSystem.registerSource(workerSource);
            this.mWebServer = new WorkerUIWebServer(NetworkAddressUtils.ServiceType.WORKER_WEB, NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.WORKER_WEB, (Configuration)this.mConfiguration), this.mBlockWorker, NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.WORKER_RPC, (Configuration)this.mConfiguration), this.mStartTimeMs, this.mConfiguration);
            this.mThriftServerSocket = this.createThriftServerSocket();
            this.mRPCPort = NetworkAddressUtils.getThriftPort((TServerSocket)this.mThriftServerSocket);
            this.mConfiguration.set("alluxio.worker.port", Integer.toString(this.mRPCPort));
            this.mThriftServer = this.createThriftServer();
            this.mWorkerAddress = NetworkAddressUtils.getConnectAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.WORKER_RPC, (Configuration)this.mConfiguration);
        }
        catch (Exception e) {
            LOG.error("Failed to initialize {}", (Object)this.getClass().getName(), (Object)e);
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        AlluxioWorker.checkArgs(args);
        AlluxioWorker worker = new AlluxioWorker();
        try {
            worker.start();
        }
        catch (Exception e) {
            LOG.error("Uncaught exception while running worker, stopping it and exiting.", (Throwable)e);
            try {
                worker.stop();
            }
            catch (Exception ex) {
                LOG.error("Uncaught exception while stopping worker, simply exiting.", (Throwable)ex);
            }
            System.exit(-1);
        }
    }

    public String getRPCBindHost() {
        return NetworkAddressUtils.getThriftSocket((TServerSocket)this.mThriftServerSocket).getInetAddress().getHostAddress();
    }

    public int getRPCLocalPort() {
        return this.mRPCPort;
    }

    public String getDataBindHost() {
        return this.mBlockWorker.getDataBindHost();
    }

    public int getDataLocalPort() {
        return this.mBlockWorker.getDataLocalPort();
    }

    public String getWebBindHost() {
        return this.mWebServer.getBindHost();
    }

    public int getWebLocalPort() {
        return this.mWebServer.getLocalPort();
    }

    public BlockWorkerClientServiceHandler getBlockWorkerServiceHandler() {
        return this.mBlockWorker.getWorkerServiceHandler();
    }

    public WorkerNetAddress getNetAddress() {
        return this.mNetAddress;
    }

    public void start() throws Exception {
        this.mWorkerMetricsSystem.start();
        this.mWebServer.addHandler((AbstractHandler)this.mWorkerMetricsSystem.getServletHandler());
        this.mWebServer.startWebServer();
        this.mNetAddress = new WorkerNetAddress().setHost(NetworkAddressUtils.getConnectHost((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.WORKER_RPC, (Configuration)this.mConfiguration)).setRpcPort(this.mConfiguration.getInt("alluxio.worker.port")).setDataPort(this.getDataLocalPort()).setWebPort(this.mConfiguration.getInt("alluxio.worker.web.port"));
        WorkerContext.setWorkerNetAddress(this.mNetAddress);
        this.startWorkers();
        LOG.info("Started worker with id {}", (Object)WorkerIdRegistry.getWorkerId());
        this.mIsServingRPC = true;
        LOG.info("Alluxio Worker version {} started @ {}", (Object)Version.VERSION, (Object)this.mWorkerAddress);
        this.mThriftServer.serve();
        LOG.info("Alluxio Worker version {} ended @ {}", (Object)Version.VERSION, (Object)this.mWorkerAddress);
    }

    public void stop() throws Exception {
        if (this.mIsServingRPC) {
            LOG.info("Stopping RPC server on Alluxio Worker @ {}", (Object)this.mWorkerAddress);
            this.stopServing();
            this.stopWorkers();
            this.mIsServingRPC = false;
        } else {
            LOG.info("Stopping Alluxio Worker @ {}", (Object)this.mWorkerAddress);
        }
    }

    private void startWorkers() throws Exception {
        this.mBlockWorker.start();
        this.mFileSystemWorker.start();
        for (Worker master : this.mAdditionalWorkers) {
            master.start();
        }
    }

    private void stopWorkers() throws Exception {
        for (Worker master : this.mAdditionalWorkers) {
            master.stop();
        }
        this.mFileSystemWorker.stop();
        this.mBlockWorker.stop();
    }

    private void stopServing() {
        this.mThriftServer.stop();
        this.mThriftServerSocket.close();
        this.mWorkerMetricsSystem.stop();
        try {
            this.mWebServer.shutdownWebServer();
        }
        catch (Exception e) {
            LOG.error("Failed to stop web server", (Throwable)e);
        }
        this.mWorkerMetricsSystem.stop();
    }

    private void registerServices(TMultiplexedProcessor processor, Map<String, TProcessor> services) {
        for (Map.Entry<String, TProcessor> service : services.entrySet()) {
            processor.registerProcessor(service.getKey(), service.getValue());
        }
    }

    private TThreadPoolServer createThriftServer() {
        TTransportFactory tTransportFactory;
        int minWorkerThreads = this.mConfiguration.getInt("alluxio.worker.block.threads.min");
        int maxWorkerThreads = this.mConfiguration.getInt("alluxio.worker.block.threads.max");
        TMultiplexedProcessor processor = new TMultiplexedProcessor();
        this.registerServices(processor, this.mBlockWorker.getServices());
        this.registerServices(processor, this.mFileSystemWorker.getServices());
        for (Worker worker : this.mAdditionalWorkers) {
            this.registerServices(processor, worker.getServices());
        }
        try {
            tTransportFactory = AuthenticationUtils.getServerTransportFactory((Configuration)this.mConfiguration);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        TThreadPoolServer.Args args = (TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)this.mThriftServerSocket).minWorkerThreads(minWorkerThreads).maxWorkerThreads(maxWorkerThreads).processor((TProcessor)processor)).transportFactory(tTransportFactory)).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(true, true));
        args.stopTimeoutVal = WorkerContext.getConf().getBoolean("alluxio.test.mode") ? 0 : 60;
        return new TThreadPoolServer(args);
    }

    private TServerSocket createThriftServerSocket() {
        try {
            return new TServerSocket(NetworkAddressUtils.getBindAddress((NetworkAddressUtils.ServiceType)NetworkAddressUtils.ServiceType.WORKER_RPC, (Configuration)this.mConfiguration));
        }
        catch (TTransportException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void checkArgs(String[] args) {
        if (args.length != 0) {
            LOG.info("Usage: java AlluxioWorker");
            System.exit(-1);
        }
    }
}

