/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker;

import alluxio.Configuration;
import alluxio.util.CommonUtils;
import alluxio.worker.block.BlockWorker;
import com.google.common.base.Throwables;
import java.io.Closeable;
import java.net.InetSocketAddress;
import javax.annotation.concurrent.ThreadSafe;

public interface DataServer
extends Closeable {
    public String getBindHost();

    public int getPort();

    public boolean isClosed();

    @ThreadSafe
    public static class Factory {
        public static DataServer create(InetSocketAddress dataAddress, BlockWorker blockWorker, Configuration conf) {
            try {
                return (DataServer)CommonUtils.createNewClassInstance((Class)conf.getClass("alluxio.worker.data.server.class"), (Class[])new Class[]{InetSocketAddress.class, BlockWorker.class, Configuration.class}, (Object[])new Object[]{dataAddress, blockWorker, conf});
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

