/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker;

import alluxio.exception.ConnectionFailedException;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.block.BlockMasterClient;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class WorkerIdRegistry {
    public static final long INVALID_WORKER_ID = 0L;
    private static AtomicLong sWorkerId = new AtomicLong(0L);

    private WorkerIdRegistry() {
    }

    public static void registerWithBlockMaster(BlockMasterClient masterClient, WorkerNetAddress workerAddress) throws IOException, ConnectionFailedException {
        sWorkerId.set(masterClient.getId(workerAddress));
    }

    public static Long getWorkerId() {
        return sWorkerId.get();
    }
}

