/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker;

import alluxio.metrics.source.Source;
import alluxio.worker.block.BlockWorker;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class WorkerSource
implements Source {
    private static final String WORKER_SOURCE_NAME = "worker";
    private boolean mGaugesRegistered = false;
    private final MetricRegistry mMetricRegistry = new MetricRegistry();
    private final Counter mBlocksAccessed = this.mMetricRegistry.counter(MetricRegistry.name((String)"BlocksAccessed", (String[])new String[0]));
    private final Counter mBlocksCanceled = this.mMetricRegistry.counter(MetricRegistry.name((String)"BlocksCanceled", (String[])new String[0]));
    private final Counter mBlocksDeleted = this.mMetricRegistry.counter(MetricRegistry.name((String)"BlocksDeleted", (String[])new String[0]));
    private final Counter mBlocksEvicted = this.mMetricRegistry.counter(MetricRegistry.name((String)"BlocksEvicted", (String[])new String[0]));
    private final Counter mBlocksPromoted = this.mMetricRegistry.counter(MetricRegistry.name((String)"BlocksPromoted", (String[])new String[0]));
    private final Counter mBlocksReadLocal = this.mMetricRegistry.counter(MetricRegistry.name((String)"BlocksReadLocal", (String[])new String[0]));
    private final Counter mBlocksReadRemote = this.mMetricRegistry.counter(MetricRegistry.name((String)"BlocksReadRemote", (String[])new String[0]));
    private final Counter mBlocksWrittenLocal = this.mMetricRegistry.counter(MetricRegistry.name((String)"BlocksWrittenLocal", (String[])new String[0]));
    private final Counter mBlocksWrittenRemote = this.mMetricRegistry.counter(MetricRegistry.name((String)"BlocksWrittenRemote", (String[])new String[0]));
    private final Counter mBytesReadLocal = this.mMetricRegistry.counter(MetricRegistry.name((String)"BytesReadLocal", (String[])new String[0]));
    private final Counter mBytesReadRemote = this.mMetricRegistry.counter(MetricRegistry.name((String)"BytesReadRemote", (String[])new String[0]));
    private final Counter mBytesReadUfs = this.mMetricRegistry.counter(MetricRegistry.name((String)"BytesReadUfs", (String[])new String[0]));
    private final Counter mBytesWrittenLocal = this.mMetricRegistry.counter(MetricRegistry.name((String)"BytesWrittenLocal", (String[])new String[0]));
    private final Counter mBytesWrittenRemote = this.mMetricRegistry.counter(MetricRegistry.name((String)"BytesWrittenRemote", (String[])new String[0]));
    private final Counter mBytesWrittenUfs = this.mMetricRegistry.counter(MetricRegistry.name((String)"BytesWrittenUfs", (String[])new String[0]));

    @Override
    public String getName() {
        return WORKER_SOURCE_NAME;
    }

    @Override
    public MetricRegistry getMetricRegistry() {
        return this.mMetricRegistry;
    }

    public void incBlocksAccessed(long n) {
        this.mBlocksAccessed.inc(n);
    }

    public void incBlocksCanceled(long n) {
        this.mBlocksCanceled.inc(n);
    }

    public void incBlocksDeleted(long n) {
        this.mBlocksDeleted.inc(n);
    }

    public void incBlocksEvicted(long n) {
        this.mBlocksEvicted.inc(n);
    }

    public void incBlocksPromoted(long n) {
        this.mBlocksPromoted.inc(n);
    }

    public void incBlocksReadLocal(long n) {
        this.mBlocksReadLocal.inc(n);
    }

    public void incBlocksReadRemote(long n) {
        this.mBlocksReadRemote.inc(n);
    }

    public void incBlocksWrittenLocal(long n) {
        this.mBlocksWrittenLocal.inc(n);
    }

    public void incBlocksWrittenRemote(long n) {
        this.mBlocksWrittenRemote.inc(n);
    }

    public void incBytesReadLocal(long n) {
        this.mBytesReadLocal.inc(n);
    }

    public void incBytesReadRemote(long n) {
        this.mBytesReadRemote.inc(n);
    }

    public void incBytesReadUfs(long n) {
        this.mBytesReadUfs.inc(n);
    }

    public void incBytesWrittenLocal(long n) {
        this.mBytesWrittenLocal.inc(n);
    }

    public void incBytesWrittenRemote(long n) {
        this.mBytesWrittenRemote.inc(n);
    }

    public void incBytesWrittenUfs(long n) {
        this.mBytesWrittenUfs.inc(n);
    }

    public void registerGauges(final BlockWorker blockWorker) {
        if (this.mGaugesRegistered) {
            return;
        }
        this.mMetricRegistry.register(MetricRegistry.name((String)"CapacityTotal", (String[])new String[0]), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return blockWorker.getStoreMeta().getCapacityBytes();
            }
        });
        this.mMetricRegistry.register(MetricRegistry.name((String)"CapacityUsed", (String[])new String[0]), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return blockWorker.getStoreMeta().getUsedBytes();
            }
        });
        this.mMetricRegistry.register(MetricRegistry.name((String)"CapacityFree", (String[])new String[0]), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return blockWorker.getStoreMeta().getCapacityBytes() - blockWorker.getStoreMeta().getUsedBytes();
            }
        });
        this.mMetricRegistry.register(MetricRegistry.name((String)"BlocksCached", (String[])new String[0]), (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return blockWorker.getStoreMeta().getNumberOfBlocks();
            }
        });
        this.mGaugesRegistered = true;
    }
}

