/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.worker.block.AbstractBlockStoreEventListener;
import alluxio.worker.block.BlockHeartbeatReport;
import alluxio.worker.block.BlockStoreLocation;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class BlockHeartbeatReporter
extends AbstractBlockStoreEventListener {
    private final Object mLock = new Object();
    private final List<Long> mRemovedBlocks = new ArrayList<Long>(100);
    private final Map<String, List<Long>> mAddedBlocks = new HashMap<String, List<Long>>(20);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlockHeartbeatReport generateReport() {
        Object object = this.mLock;
        synchronized (object) {
            HashMap<String, List<Long>> addedBlocks = new HashMap<String, List<Long>>(this.mAddedBlocks);
            ArrayList<Long> removedBlocks = new ArrayList<Long>(this.mRemovedBlocks);
            this.mAddedBlocks.clear();
            this.mRemovedBlocks.clear();
            return new BlockHeartbeatReport(addedBlocks, removedBlocks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMoveBlockByClient(long sessionId, long blockId, BlockStoreLocation oldLocation, BlockStoreLocation newLocation) {
        Object object = this.mLock;
        synchronized (object) {
            this.removeBlockFromAddedBlocks(blockId);
            this.addBlockToAddedBlocks(blockId, newLocation.tierAlias());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRemoveBlockByClient(long sessionId, long blockId) {
        Object object = this.mLock;
        synchronized (object) {
            this.removeBlockFromAddedBlocks(blockId);
            if (!this.mRemovedBlocks.contains(blockId)) {
                this.mRemovedBlocks.add(blockId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRemoveBlockByWorker(long sessionId, long blockId) {
        Object object = this.mLock;
        synchronized (object) {
            this.removeBlockFromAddedBlocks(blockId);
            if (!this.mRemovedBlocks.contains(blockId)) {
                this.mRemovedBlocks.add(blockId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onMoveBlockByWorker(long sessionId, long blockId, BlockStoreLocation oldLocation, BlockStoreLocation newLocation) {
        Object object = this.mLock;
        synchronized (object) {
            this.removeBlockFromAddedBlocks(blockId);
            this.addBlockToAddedBlocks(blockId, newLocation.tierAlias());
        }
    }

    private void addBlockToAddedBlocks(long blockId, String tierAlias) {
        if (this.mAddedBlocks.containsKey(tierAlias)) {
            this.mAddedBlocks.get(tierAlias).add(blockId);
        } else {
            this.mAddedBlocks.put(tierAlias, Lists.newArrayList((Object[])new Long[]{blockId}));
        }
    }

    private void removeBlockFromAddedBlocks(long blockId) {
        Iterator<Map.Entry<String, List<Long>>> iterator = this.mAddedBlocks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<Long>> entry = iterator.next();
            List<Long> blockList = entry.getValue();
            if (!blockList.contains(blockId)) continue;
            blockList.remove(blockId);
            if (!blockList.isEmpty()) break;
            iterator.remove();
            break;
        }
    }
}

