/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.worker.WorkerContext;
import alluxio.worker.block.BlockLockType;
import alluxio.worker.block.ClientRWLock;
import com.google.common.collect.Sets;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class BlockLockManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final int NUM_LOCKS = WorkerContext.getConf().getInt("alluxio.worker.tieredstore.block.locks");
    private static final AtomicLong LOCK_ID_GEN = new AtomicLong(0L);
    private static final HashFunction HASH_FUNC = Hashing.murmur3_32();
    private final ClientRWLock[] mLockArray = new ClientRWLock[NUM_LOCKS];
    @GuardedBy(value="mSharedMapsLock")
    private final Map<Long, Set<Long>> mSessionIdToLockIdsMap = new HashMap<Long, Set<Long>>();
    @GuardedBy(value="mSharedMapsLock")
    private final Map<Long, LockRecord> mLockIdToRecordMap = new HashMap<Long, LockRecord>();
    private final Object mSharedMapsLock = new Object();

    public BlockLockManager() {
        for (int i = 0; i < NUM_LOCKS; ++i) {
            this.mLockArray[i] = new ClientRWLock();
        }
    }

    public static int blockHashIndex(long blockId) {
        return Math.abs(HASH_FUNC.hashLong(blockId).asInt()) % NUM_LOCKS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lockBlock(long sessionId, long blockId, BlockLockType blockLockType) {
        int index = BlockLockManager.blockHashIndex(blockId);
        ClientRWLock blockLock = this.mLockArray[index];
        Lock lock = blockLockType == BlockLockType.READ ? blockLock.readLock() : blockLock.writeLock();
        lock.lock();
        long lockId = LOCK_ID_GEN.getAndIncrement();
        Object object = this.mSharedMapsLock;
        synchronized (object) {
            this.mLockIdToRecordMap.put(lockId, new LockRecord(sessionId, blockId, lock));
            Set<Long> sessionLockIds = this.mSessionIdToLockIdsMap.get(sessionId);
            if (sessionLockIds == null) {
                this.mSessionIdToLockIdsMap.put(sessionId, Sets.newHashSet((Object[])new Long[]{lockId}));
            } else {
                sessionLockIds.add(lockId);
            }
        }
        return lockId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockBlock(long lockId) throws BlockDoesNotExistException {
        Lock lock;
        Object object = this.mSharedMapsLock;
        synchronized (object) {
            LockRecord record = this.mLockIdToRecordMap.get(lockId);
            if (record == null) {
                throw new BlockDoesNotExistException(ExceptionMessage.LOCK_RECORD_NOT_FOUND_FOR_LOCK_ID, new Object[]{lockId});
            }
            long sessionId = record.getSessionId();
            lock = record.getLock();
            this.mLockIdToRecordMap.remove(lockId);
            Set<Long> sessionLockIds = this.mSessionIdToLockIdsMap.get(sessionId);
            sessionLockIds.remove(lockId);
            if (sessionLockIds.isEmpty()) {
                this.mSessionIdToLockIdsMap.remove(sessionId);
            }
        }
        lock.unlock();
    }

    public void unlockBlock(long sessionId, long blockId) throws BlockDoesNotExistException {
        Object object = this.mSharedMapsLock;
        synchronized (object) {
            Set<Long> sessionLockIds = this.mSessionIdToLockIdsMap.get(sessionId);
            for (long lockId : sessionLockIds) {
                LockRecord record = this.mLockIdToRecordMap.get(lockId);
                if (record == null) {
                    throw new BlockDoesNotExistException(ExceptionMessage.LOCK_RECORD_NOT_FOUND_FOR_LOCK_ID, new Object[]{lockId});
                }
                if (blockId != record.getBlockId()) continue;
                this.mLockIdToRecordMap.remove(lockId);
                sessionLockIds.remove(lockId);
                if (sessionLockIds.isEmpty()) {
                    this.mSessionIdToLockIdsMap.remove(sessionId);
                }
                Lock lock = record.getLock();
                lock.unlock();
                return;
            }
            throw new BlockDoesNotExistException(ExceptionMessage.LOCK_RECORD_NOT_FOUND_FOR_BLOCK_AND_SESSION, new Object[]{blockId, sessionId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateLock(long sessionId, long blockId, long lockId) throws BlockDoesNotExistException, InvalidWorkerStateException {
        Object object = this.mSharedMapsLock;
        synchronized (object) {
            LockRecord record = this.mLockIdToRecordMap.get(lockId);
            if (record == null) {
                throw new BlockDoesNotExistException(ExceptionMessage.LOCK_RECORD_NOT_FOUND_FOR_LOCK_ID, new Object[]{lockId});
            }
            if (sessionId != record.getSessionId()) {
                throw new InvalidWorkerStateException(ExceptionMessage.LOCK_ID_FOR_DIFFERENT_SESSION, new Object[]{lockId, record.getSessionId(), sessionId});
            }
            if (blockId != record.getBlockId()) {
                throw new InvalidWorkerStateException(ExceptionMessage.LOCK_ID_FOR_DIFFERENT_BLOCK, new Object[]{lockId, record.getBlockId(), blockId});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupSession(long sessionId) {
        Object object = this.mSharedMapsLock;
        synchronized (object) {
            Set<Long> sessionLockIds = this.mSessionIdToLockIdsMap.get(sessionId);
            if (sessionLockIds == null) {
                return;
            }
            for (long lockId : sessionLockIds) {
                LockRecord record = this.mLockIdToRecordMap.get(lockId);
                if (record == null) {
                    LOG.error(ExceptionMessage.LOCK_RECORD_NOT_FOUND_FOR_LOCK_ID.getMessage(new Object[]{lockId}));
                    continue;
                }
                Lock lock = record.getLock();
                lock.unlock();
                this.mLockIdToRecordMap.remove(lockId);
            }
            this.mSessionIdToLockIdsMap.remove(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Long> getLockedBlocks() {
        Object object = this.mSharedMapsLock;
        synchronized (object) {
            HashSet<Long> set = new HashSet<Long>();
            for (LockRecord lockRecord : this.mLockIdToRecordMap.values()) {
                set.add(lockRecord.getBlockId());
            }
            return set;
        }
    }

    @ThreadSafe
    private static final class LockRecord {
        private final long mSessionId;
        private final long mBlockId;
        private final Lock mLock;

        LockRecord(long sessionId, long blockId, Lock lock) {
            this.mSessionId = sessionId;
            this.mBlockId = blockId;
            this.mLock = lock;
        }

        long getSessionId() {
            return this.mSessionId;
        }

        long getBlockId() {
            return this.mBlockId;
        }

        Lock getLock() {
            return this.mLock;
        }
    }
}

