/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.AbstractClient;
import alluxio.AbstractMasterClient;
import alluxio.Configuration;
import alluxio.exception.AlluxioException;
import alluxio.exception.ConnectionFailedException;
import alluxio.thrift.AlluxioService;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.BlockMasterWorkerService;
import alluxio.thrift.Command;
import alluxio.thrift.WorkerNetAddress;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class BlockMasterClient
extends AbstractMasterClient {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private BlockMasterWorkerService.Client mClient = null;

    public BlockMasterClient(InetSocketAddress masterAddress, Configuration configuration) {
        super(masterAddress, configuration);
    }

    protected AlluxioService.Client getClient() {
        return this.mClient;
    }

    protected String getServiceName() {
        return "BlockMasterWorker";
    }

    protected long getServiceVersion() {
        return 1L;
    }

    protected void afterConnect() throws IOException {
        this.mClient = new BlockMasterWorkerService.Client(this.mProtocol);
    }

    public synchronized void commitBlock(final long workerId, final long usedBytesOnTier, final String tierAlias, final long blockId, final long length) throws IOException, ConnectionFailedException {
        this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<Void>(){

            public Void call() throws TException {
                BlockMasterClient.this.mClient.commitBlock(workerId, usedBytesOnTier, tierAlias, blockId, length);
                return null;
            }
        });
    }

    public synchronized long getId(final alluxio.wire.WorkerNetAddress address) throws IOException, ConnectionFailedException {
        return (Long)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<Long>(){

            public Long call() throws TException {
                return BlockMasterClient.this.mClient.getWorkerId(new WorkerNetAddress(address.getHost(), address.getRpcPort(), address.getDataPort(), address.getWebPort()));
            }
        });
    }

    public synchronized Command heartbeat(final long workerId, final Map<String, Long> usedBytesOnTiers, final List<Long> removedBlocks, final Map<String, List<Long>> addedBlocks) throws IOException, ConnectionFailedException {
        return (Command)this.retryRPC((AbstractClient.RpcCallable)new AbstractClient.RpcCallable<Command>(){

            public Command call() throws TException {
                return BlockMasterClient.this.mClient.heartbeat(workerId, usedBytesOnTiers, removedBlocks, addedBlocks);
            }
        });
    }

    public synchronized void register(final long workerId, final List<String> storageTierAliases, final Map<String, Long> totalBytesOnTiers, final Map<String, Long> usedBytesOnTiers, final Map<String, List<Long>> currentBlocksOnTiers) throws AlluxioException, IOException {
        this.retryRPC((AbstractClient.RpcCallableThrowsAlluxioTException)new AbstractClient.RpcCallableThrowsAlluxioTException<Void>(){

            public Void call() throws AlluxioTException, TException {
                BlockMasterClient.this.mClient.registerWorker(workerId, storageTierAliases, totalBytesOnTiers, usedBytesOnTiers, currentBlocksOnTiers);
                return null;
            }
        });
    }
}

