/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.Configuration;
import alluxio.WorkerStorageTierAssoc;
import alluxio.exception.AlluxioException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.ConnectionFailedException;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.heartbeat.HeartbeatExecutor;
import alluxio.thrift.Command;
import alluxio.util.ThreadFactoryUtils;
import alluxio.wire.WorkerNetAddress;
import alluxio.worker.WorkerContext;
import alluxio.worker.WorkerIdRegistry;
import alluxio.worker.block.BlockHeartbeatReport;
import alluxio.worker.block.BlockMasterClient;
import alluxio.worker.block.BlockStoreMeta;
import alluxio.worker.block.BlockWorker;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class BlockMasterSync
implements HeartbeatExecutor {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static final int DEFAULT_BLOCK_REMOVER_POOL_SIZE = 10;
    private final BlockWorker mBlockWorker;
    private final WorkerNetAddress mWorkerAddress;
    private final int mHeartbeatTimeoutMs;
    private final BlockMasterClient mMasterClient;
    private final ExecutorService mBlockRemovalService = Executors.newFixedThreadPool(10, ThreadFactoryUtils.build((String)"block-removal-service-%d", (boolean)true));
    private long mLastSuccessfulHeartbeatMs;

    BlockMasterSync(BlockWorker blockWorker, WorkerNetAddress workerAddress, BlockMasterClient masterClient) {
        this.mBlockWorker = blockWorker;
        this.mWorkerAddress = workerAddress;
        Configuration conf = WorkerContext.getConf();
        this.mMasterClient = masterClient;
        this.mHeartbeatTimeoutMs = conf.getInt("alluxio.worker.block.heartbeat.timeout.ms");
        try {
            this.registerWithMaster();
            this.mLastSuccessfulHeartbeatMs = System.currentTimeMillis();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to register with master.", e);
        }
        catch (ConnectionFailedException e) {
            throw new RuntimeException("Failed to register with master.", e);
        }
    }

    private void registerWithMaster() throws IOException, ConnectionFailedException {
        BlockStoreMeta storeMeta = this.mBlockWorker.getStoreMeta();
        try {
            WorkerStorageTierAssoc storageTierAssoc = new WorkerStorageTierAssoc(WorkerContext.getConf());
            this.mMasterClient.register(WorkerIdRegistry.getWorkerId(), storageTierAssoc.getOrderedStorageAliases(), storeMeta.getCapacityBytesOnTiers(), storeMeta.getUsedBytesOnTiers(), storeMeta.getBlockList());
        }
        catch (IOException e) {
            LOG.error("Failed to register with master.", (Throwable)e);
            throw e;
        }
        catch (AlluxioException e) {
            LOG.error("Failed to register with master.", (Throwable)e);
            throw new IOException(e);
        }
    }

    public void heartbeat() {
        block4: {
            BlockHeartbeatReport blockReport = this.mBlockWorker.getReport();
            BlockStoreMeta storeMeta = this.mBlockWorker.getStoreMeta();
            Command cmdFromMaster = null;
            try {
                cmdFromMaster = this.mMasterClient.heartbeat(WorkerIdRegistry.getWorkerId(), storeMeta.getUsedBytesOnTiers(), blockReport.getRemovedBlocks(), blockReport.getAddedBlocks());
                this.handleMasterCommand(cmdFromMaster);
                this.mLastSuccessfulHeartbeatMs = System.currentTimeMillis();
            }
            catch (Exception e) {
                if (cmdFromMaster == null) {
                    LOG.error("Failed to receive master heartbeat command.", (Throwable)e);
                } else {
                    LOG.error("Failed to receive or execute master heartbeat command: {}", (Object)cmdFromMaster.toString(), (Object)e);
                }
                this.mMasterClient.resetConnection();
                if (System.currentTimeMillis() - this.mLastSuccessfulHeartbeatMs < (long)this.mHeartbeatTimeoutMs) break block4;
                throw new RuntimeException("Master heartbeat timeout exceeded: " + this.mHeartbeatTimeoutMs);
            }
        }
    }

    public void close() {
        this.mBlockRemovalService.shutdown();
    }

    private void handleMasterCommand(Command cmd) throws Exception {
        if (cmd == null) {
            return;
        }
        switch (cmd.getCommandType()) {
            case Delete: {
                break;
            }
            case Free: {
                Iterator i$ = cmd.getData().iterator();
                while (i$.hasNext()) {
                    long block = (Long)i$.next();
                    this.mBlockRemovalService.execute(new BlockRemover(this.mBlockWorker, -4L, block));
                }
                break;
            }
            case Nothing: {
                break;
            }
            case Register: {
                WorkerIdRegistry.registerWithBlockMaster(this.mMasterClient, this.mWorkerAddress);
                this.registerWithMaster();
                break;
            }
            case Unknown: {
                LOG.error("Master heartbeat sends unknown command {}", (Object)cmd);
                break;
            }
            default: {
                throw new RuntimeException("Un-recognized command from master " + cmd);
            }
        }
    }

    @NotThreadSafe
    private class BlockRemover
    implements Runnable {
        private BlockWorker mBlockWorker;
        private long mSessionId;
        private long mBlockId;

        public BlockRemover(BlockWorker blockWorker, long sessionId, long blockId) {
            this.mBlockWorker = blockWorker;
            this.mSessionId = sessionId;
            this.mBlockId = blockId;
        }

        @Override
        public void run() {
            try {
                this.mBlockWorker.removeBlock(this.mSessionId, this.mBlockId);
                LOG.info("Block {} removed at session {}", (Object)this.mBlockId, (Object)this.mSessionId);
            }
            catch (IOException e) {
                LOG.warn("Failed master free block cmd for: {} due to concurrent read.", (Object)this.mBlockId, (Object)e);
            }
            catch (InvalidWorkerStateException e) {
                LOG.warn("Failed master free block cmd for: {} due to block uncommitted.", (Object)this.mBlockId, (Object)e);
            }
            catch (BlockDoesNotExistException e) {
                LOG.warn("Failed master free block cmd for: {} due to block not found.", (Object)this.mBlockId, (Object)e);
            }
        }
    }
}

