/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.WorkerStorageTierAssoc;
import alluxio.exception.BlockAlreadyExistsException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.exception.WorkerOutOfSpaceException;
import alluxio.worker.WorkerContext;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.BlockStoreMeta;
import alluxio.worker.block.meta.AbstractBlockMeta;
import alluxio.worker.block.meta.BlockMeta;
import alluxio.worker.block.meta.StorageDir;
import alluxio.worker.block.meta.StorageTier;
import alluxio.worker.block.meta.TempBlockMeta;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class BlockMetadataManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final List<StorageTier> mTiers;
    private final Map<String, StorageTier> mAliasToTiers;

    private BlockMetadataManager() {
        try {
            WorkerStorageTierAssoc storageTierAssoc = new WorkerStorageTierAssoc(WorkerContext.getConf());
            this.mAliasToTiers = new HashMap<String, StorageTier>(storageTierAssoc.size());
            this.mTiers = new ArrayList<StorageTier>(storageTierAssoc.size());
            for (int tierOrdinal = 0; tierOrdinal < storageTierAssoc.size(); ++tierOrdinal) {
                StorageTier tier = StorageTier.newStorageTier(storageTierAssoc.getAlias(tierOrdinal));
                this.mTiers.add(tier);
                this.mAliasToTiers.put(tier.getTierAlias(), tier);
            }
        }
        catch (BlockAlreadyExistsException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (WorkerOutOfSpaceException e) {
            throw new RuntimeException(e);
        }
    }

    public static BlockMetadataManager createBlockMetadataManager() {
        return new BlockMetadataManager();
    }

    public void abortTempBlockMeta(TempBlockMeta tempBlockMeta) throws BlockDoesNotExistException {
        StorageDir dir = tempBlockMeta.getParentDir();
        dir.removeTempBlockMeta(tempBlockMeta);
    }

    public void addTempBlockMeta(TempBlockMeta tempBlockMeta) throws WorkerOutOfSpaceException, BlockAlreadyExistsException {
        StorageDir dir = tempBlockMeta.getParentDir();
        dir.addTempBlockMeta(tempBlockMeta);
    }

    public void commitTempBlockMeta(TempBlockMeta tempBlockMeta) throws WorkerOutOfSpaceException, BlockAlreadyExistsException, BlockDoesNotExistException {
        long blockId = tempBlockMeta.getBlockId();
        if (this.hasBlockMeta(blockId)) {
            BlockMeta blockMeta = this.getBlockMeta(blockId);
            throw new BlockAlreadyExistsException(ExceptionMessage.ADD_EXISTING_BLOCK.getMessage(new Object[]{blockId, blockMeta.getBlockLocation().tierAlias()}));
        }
        BlockMeta block = new BlockMeta((TempBlockMeta)Preconditions.checkNotNull((Object)tempBlockMeta));
        StorageDir dir = tempBlockMeta.getParentDir();
        dir.removeTempBlockMeta(tempBlockMeta);
        dir.addBlockMeta(block);
    }

    @Deprecated
    public void cleanupSessionTempBlocks(long sessionId, List<Long> tempBlockIds) {
        for (StorageTier tier : this.mTiers) {
            for (StorageDir dir : tier.getStorageDirs()) {
                dir.cleanupSessionTempBlocks(sessionId, tempBlockIds);
            }
        }
    }

    public long getAvailableBytes(BlockStoreLocation location) {
        long spaceAvailable = 0L;
        if (location.equals(BlockStoreLocation.anyTier())) {
            for (StorageTier tier : this.mTiers) {
                spaceAvailable += tier.getAvailableBytes();
            }
            return spaceAvailable;
        }
        String tierAlias = location.tierAlias();
        StorageTier tier = this.getTier(tierAlias);
        if (location.equals(BlockStoreLocation.anyDirInTier(tierAlias))) {
            return tier.getAvailableBytes();
        }
        int dirIndex = location.dir();
        StorageDir dir = tier.getDir(dirIndex);
        return dir.getAvailableBytes();
    }

    public BlockMeta getBlockMeta(long blockId) throws BlockDoesNotExistException {
        for (StorageTier tier : this.mTiers) {
            for (StorageDir dir : tier.getStorageDirs()) {
                if (!dir.hasBlockMeta(blockId)) continue;
                return dir.getBlockMeta(blockId);
            }
        }
        throw new BlockDoesNotExistException(ExceptionMessage.BLOCK_META_NOT_FOUND, new Object[]{blockId});
    }

    public String getBlockPath(long blockId, BlockStoreLocation location) {
        return AbstractBlockMeta.commitPath(this.getDir(location), blockId);
    }

    public BlockStoreMeta getBlockStoreMeta() {
        return new BlockStoreMeta(this);
    }

    public StorageDir getDir(BlockStoreLocation location) {
        if (location.equals(BlockStoreLocation.anyTier()) || location.equals(BlockStoreLocation.anyDirInTier(location.tierAlias()))) {
            throw new IllegalArgumentException(ExceptionMessage.GET_DIR_FROM_NON_SPECIFIC_LOCATION.getMessage(new Object[]{location}));
        }
        return this.getTier(location.tierAlias()).getDir(location.dir());
    }

    public TempBlockMeta getTempBlockMeta(long blockId) throws BlockDoesNotExistException {
        for (StorageTier tier : this.mTiers) {
            for (StorageDir dir : tier.getStorageDirs()) {
                if (!dir.hasTempBlockMeta(blockId)) continue;
                return dir.getTempBlockMeta(blockId);
            }
        }
        throw new BlockDoesNotExistException(ExceptionMessage.TEMP_BLOCK_META_NOT_FOUND, new Object[]{blockId});
    }

    public StorageTier getTier(String tierAlias) {
        StorageTier tier = this.mAliasToTiers.get(tierAlias);
        if (tier == null) {
            throw new IllegalArgumentException(ExceptionMessage.TIER_ALIAS_NOT_FOUND.getMessage(new Object[]{tierAlias}));
        }
        return tier;
    }

    public List<StorageTier> getTiers() {
        return this.mTiers;
    }

    public List<StorageTier> getTiersBelow(String tierAlias) {
        int ordinal = this.getTier(tierAlias).getTierOrdinal();
        return this.mTiers.subList(ordinal + 1, this.mTiers.size());
    }

    public List<TempBlockMeta> getSessionTempBlocks(long sessionId) {
        ArrayList<TempBlockMeta> sessionTempBlocks = new ArrayList<TempBlockMeta>();
        for (StorageTier tier : this.mTiers) {
            for (StorageDir dir : tier.getStorageDirs()) {
                sessionTempBlocks.addAll(dir.getSessionTempBlocks(sessionId));
            }
        }
        return sessionTempBlocks;
    }

    public boolean hasBlockMeta(long blockId) {
        for (StorageTier tier : this.mTiers) {
            for (StorageDir dir : tier.getStorageDirs()) {
                if (!dir.hasBlockMeta(blockId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasTempBlockMeta(long blockId) {
        for (StorageTier tier : this.mTiers) {
            for (StorageDir dir : tier.getStorageDirs()) {
                if (!dir.hasTempBlockMeta(blockId)) continue;
                return true;
            }
        }
        return false;
    }

    public BlockMeta moveBlockMeta(BlockMeta blockMeta, TempBlockMeta tempBlockMeta) throws BlockDoesNotExistException, WorkerOutOfSpaceException, BlockAlreadyExistsException {
        StorageDir srcDir = blockMeta.getParentDir();
        StorageDir dstDir = tempBlockMeta.getParentDir();
        srcDir.removeBlockMeta(blockMeta);
        BlockMeta newBlockMeta = new BlockMeta(blockMeta.getBlockId(), blockMeta.getBlockSize(), dstDir);
        dstDir.removeTempBlockMeta(tempBlockMeta);
        dstDir.addBlockMeta(newBlockMeta);
        return newBlockMeta;
    }

    @Deprecated
    public BlockMeta moveBlockMeta(BlockMeta blockMeta, BlockStoreLocation newLocation) throws BlockDoesNotExistException, BlockAlreadyExistsException, WorkerOutOfSpaceException {
        BlockStoreLocation oldLocation = blockMeta.getBlockLocation();
        if (oldLocation.belongsTo(newLocation)) {
            LOG.info("moveBlockMeta: moving {} to {} is a noop", (Object)oldLocation, (Object)newLocation);
            return blockMeta;
        }
        long blockSize = blockMeta.getBlockSize();
        String newTierAlias = newLocation.tierAlias();
        StorageTier newTier = this.getTier(newTierAlias);
        StorageDir newDir = null;
        if (newLocation.equals(BlockStoreLocation.anyDirInTier(newTierAlias))) {
            for (StorageDir dir : newTier.getStorageDirs()) {
                if (dir.getAvailableBytes() < blockSize) continue;
                newDir = dir;
                break;
            }
        } else {
            StorageDir dir = newTier.getDir(newLocation.dir());
            if (dir.getAvailableBytes() >= blockSize) {
                newDir = dir;
            }
        }
        if (newDir == null) {
            throw new WorkerOutOfSpaceException("Failed to move BlockMeta: newLocation " + newLocation + " does not have enough space for " + blockSize + " bytes");
        }
        StorageDir oldDir = blockMeta.getParentDir();
        oldDir.removeBlockMeta(blockMeta);
        BlockMeta newBlockMeta = new BlockMeta(blockMeta.getBlockId(), blockSize, newDir);
        newDir.addBlockMeta(newBlockMeta);
        return newBlockMeta;
    }

    public void removeBlockMeta(BlockMeta block) throws BlockDoesNotExistException {
        StorageDir dir = block.getParentDir();
        dir.removeBlockMeta(block);
    }

    public void resizeTempBlockMeta(TempBlockMeta tempBlockMeta, long newSize) throws InvalidWorkerStateException {
        StorageDir dir = tempBlockMeta.getParentDir();
        dir.resizeTempBlockMeta(tempBlockMeta, newSize);
    }
}

