/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.ExceptionMessage;
import alluxio.master.block.BlockId;
import alluxio.worker.block.BlockLockManager;
import alluxio.worker.block.BlockMetadataManager;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.meta.BlockMeta;
import alluxio.worker.block.meta.StorageDirView;
import alluxio.worker.block.meta.StorageTier;
import alluxio.worker.block.meta.StorageTierView;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BlockMetadataManagerView {
    private final BlockMetadataManager mMetadataManager;
    private List<StorageTierView> mTierViews = new ArrayList<StorageTierView>();
    private final Set<Long> mPinnedInodes = new HashSet<Long>();
    private final BitSet mInUseLocks = new BitSet();
    private Map<String, StorageTierView> mAliasToTierViews = new HashMap<String, StorageTierView>();

    public BlockMetadataManagerView(BlockMetadataManager manager, Set<Long> pinnedInodes, Set<Long> lockedBlocks) {
        this.mMetadataManager = (BlockMetadataManager)Preconditions.checkNotNull((Object)manager);
        this.mPinnedInodes.addAll((Collection)Preconditions.checkNotNull(pinnedInodes));
        Preconditions.checkNotNull(lockedBlocks);
        for (Long blockId : lockedBlocks) {
            this.mInUseLocks.set(BlockLockManager.blockHashIndex(blockId));
        }
        for (StorageTier tier : manager.getTiers()) {
            StorageTierView tierView = new StorageTierView(tier, this);
            this.mTierViews.add(tierView);
            this.mAliasToTierViews.put(tier.getTierAlias(), tierView);
        }
    }

    public void clearBlockMarks() {
        for (StorageTierView tierView : this.mTierViews) {
            for (StorageDirView dirView : tierView.getDirViews()) {
                dirView.clearBlockMarks();
            }
        }
    }

    public boolean isBlockPinned(long blockId) {
        return this.mPinnedInodes.contains(BlockId.createBlockId((long)BlockId.getContainerId((long)blockId), (long)BlockId.getMaxSequenceNumber()));
    }

    public boolean isBlockLocked(long blockId) {
        int index = BlockLockManager.blockHashIndex(blockId);
        if (index < this.mInUseLocks.length()) {
            return this.mInUseLocks.get(index);
        }
        return false;
    }

    public boolean isBlockEvictable(long blockId) {
        return !this.isBlockPinned(blockId) && !this.isBlockLocked(blockId) && !this.isBlockMarked(blockId);
    }

    public boolean isBlockMarked(long blockId) {
        for (StorageTierView tierView : this.mTierViews) {
            for (StorageDirView dirView : tierView.getDirViews()) {
                if (!dirView.isMarkedToMoveOut(blockId)) continue;
                return true;
            }
        }
        return false;
    }

    public StorageTierView getTierView(String tierAlias) {
        StorageTierView tierView = this.mAliasToTierViews.get(tierAlias);
        if (tierView == null) {
            throw new IllegalArgumentException(ExceptionMessage.TIER_VIEW_ALIAS_NOT_FOUND.getMessage(new Object[]{tierAlias}));
        }
        return tierView;
    }

    public List<StorageTierView> getTierViews() {
        return Collections.unmodifiableList(this.mTierViews);
    }

    public List<StorageTierView> getTierViewsBelow(String tierAlias) {
        int ordinal = this.getTierView(tierAlias).getTierViewOrdinal();
        return this.mTierViews.subList(ordinal + 1, this.mTierViews.size());
    }

    public StorageTierView getNextTier(StorageTierView tierView) {
        int nextOrdinal = tierView.getTierViewOrdinal() + 1;
        if (nextOrdinal < this.mTierViews.size()) {
            return this.mTierViews.get(nextOrdinal);
        }
        return null;
    }

    public long getAvailableBytes(BlockStoreLocation location) {
        return this.mMetadataManager.getAvailableBytes(location);
    }

    public BlockMeta getBlockMeta(long blockId) throws BlockDoesNotExistException {
        if (this.isBlockEvictable(blockId)) {
            return this.mMetadataManager.getBlockMeta(blockId);
        }
        return null;
    }
}

