/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.StorageTierAssoc;
import alluxio.WorkerStorageTierAssoc;
import alluxio.worker.WorkerContext;
import alluxio.worker.WorkerSource;
import alluxio.worker.block.AbstractBlockStoreEventListener;
import alluxio.worker.block.BlockStoreLocation;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class BlockMetricsReporter
extends AbstractBlockStoreEventListener {
    private final WorkerSource mWorkerSource;
    private final StorageTierAssoc mStorageTierAssoc;

    public BlockMetricsReporter(WorkerSource workerSource) {
        this.mWorkerSource = workerSource;
        this.mStorageTierAssoc = new WorkerStorageTierAssoc(WorkerContext.getConf());
    }

    @Override
    public void onAccessBlock(long sessionId, long blockId) {
        this.mWorkerSource.incBlocksAccessed(1L);
    }

    @Override
    public void onMoveBlockByClient(long sessionId, long blockId, BlockStoreLocation oldLocation, BlockStoreLocation newLocation) {
        int oldTierOrdinal = this.mStorageTierAssoc.getOrdinal(oldLocation.tierAlias());
        int newTierOrdinal = this.mStorageTierAssoc.getOrdinal(newLocation.tierAlias());
        if (newTierOrdinal == 0 && oldTierOrdinal != newTierOrdinal) {
            this.mWorkerSource.incBlocksPromoted(1L);
        }
    }

    @Override
    public void onRemoveBlockByClient(long sessionId, long blockId) {
        this.mWorkerSource.incBlocksDeleted(1L);
    }

    @Override
    public void onMoveBlockByWorker(long sessionId, long blockId, BlockStoreLocation oldLocation, BlockStoreLocation newLocation) {
        int oldTierOrdinal = this.mStorageTierAssoc.getOrdinal(oldLocation.tierAlias());
        int newTierOrdinal = this.mStorageTierAssoc.getOrdinal(newLocation.tierAlias());
        if (newTierOrdinal == 0 && oldTierOrdinal != newTierOrdinal) {
            this.mWorkerSource.incBlocksPromoted(1L);
        }
    }

    @Override
    public void onRemoveBlockByWorker(long sessionId, long blockId) {
        this.mWorkerSource.incBlocksEvicted(1L);
    }

    @Override
    public void onAbortBlock(long sessionId, long blockId) {
        this.mWorkerSource.incBlocksCanceled(1L);
    }

    public void updateClientMetrics(List<Long> metrics) {
        if (metrics != null && !metrics.isEmpty() && metrics.get(0) == 1L) {
            this.mWorkerSource.incBlocksReadLocal(metrics.get(1));
            this.mWorkerSource.incBlocksReadRemote(metrics.get(2));
            this.mWorkerSource.incBlocksWrittenLocal(metrics.get(3));
            this.mWorkerSource.incBlocksWrittenRemote(metrics.get(4));
            this.mWorkerSource.incBytesReadLocal(metrics.get(5));
            this.mWorkerSource.incBytesReadRemote(metrics.get(6));
            this.mWorkerSource.incBytesReadUfs(metrics.get(7));
            this.mWorkerSource.incBytesWrittenLocal(metrics.get(8));
            this.mWorkerSource.incBytesWrittenRemote(metrics.get(9));
            this.mWorkerSource.incBytesWrittenUfs(metrics.get(10));
        }
    }
}

