/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.exception.BlockAlreadyExistsException;
import alluxio.exception.BlockDoesNotExistException;
import alluxio.exception.InvalidWorkerStateException;
import alluxio.exception.WorkerOutOfSpaceException;
import alluxio.worker.block.BlockStoreEventListener;
import alluxio.worker.block.BlockStoreLocation;
import alluxio.worker.block.BlockStoreMeta;
import alluxio.worker.block.io.BlockReader;
import alluxio.worker.block.io.BlockWriter;
import alluxio.worker.block.meta.BlockMeta;
import alluxio.worker.block.meta.TempBlockMeta;
import java.io.IOException;
import java.util.Set;

interface BlockStore {
    public long lockBlock(long var1, long var3) throws BlockDoesNotExistException;

    public void unlockBlock(long var1) throws BlockDoesNotExistException;

    public void unlockBlock(long var1, long var3) throws BlockDoesNotExistException;

    public TempBlockMeta createBlockMeta(long var1, long var3, BlockStoreLocation var5, long var6) throws BlockAlreadyExistsException, WorkerOutOfSpaceException, IOException;

    public BlockMeta getVolatileBlockMeta(long var1) throws BlockDoesNotExistException;

    public BlockMeta getBlockMeta(long var1, long var3, long var5) throws BlockDoesNotExistException, InvalidWorkerStateException;

    public void commitBlock(long var1, long var3) throws BlockAlreadyExistsException, BlockDoesNotExistException, InvalidWorkerStateException, IOException, WorkerOutOfSpaceException;

    public void abortBlock(long var1, long var3) throws BlockAlreadyExistsException, BlockDoesNotExistException, InvalidWorkerStateException, IOException;

    public void requestSpace(long var1, long var3, long var5) throws BlockDoesNotExistException, WorkerOutOfSpaceException, IOException;

    public BlockWriter getBlockWriter(long var1, long var3) throws BlockDoesNotExistException, IOException;

    public BlockReader getBlockReader(long var1, long var3, long var5) throws BlockDoesNotExistException, InvalidWorkerStateException, IOException;

    public void moveBlock(long var1, long var3, BlockStoreLocation var5) throws BlockDoesNotExistException, BlockAlreadyExistsException, InvalidWorkerStateException, WorkerOutOfSpaceException, IOException;

    public void moveBlock(long var1, long var3, BlockStoreLocation var5, BlockStoreLocation var6) throws BlockDoesNotExistException, BlockAlreadyExistsException, InvalidWorkerStateException, WorkerOutOfSpaceException, IOException;

    public void removeBlock(long var1, long var3) throws InvalidWorkerStateException, BlockDoesNotExistException, IOException;

    public void removeBlock(long var1, long var3, BlockStoreLocation var5) throws InvalidWorkerStateException, BlockDoesNotExistException, IOException;

    public void accessBlock(long var1, long var3) throws BlockDoesNotExistException;

    public BlockStoreMeta getBlockStoreMeta();

    public boolean hasBlockMeta(long var1);

    public void cleanupSession(long var1);

    public void freeSpace(long var1, long var3, BlockStoreLocation var5) throws WorkerOutOfSpaceException, BlockDoesNotExistException, IOException;

    public void registerBlockStoreEventListener(BlockStoreEventListener var1);

    public void updatePinnedInodes(Set<Long> var1);
}

