/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import java.util.Arrays;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class BlockStoreLocation {
    private static final String ANY_TIER = "";
    private static final int ANY_DIR = -1;
    private final String mTierAlias;
    private final int mDirIndex;

    public static BlockStoreLocation anyTier() {
        return new BlockStoreLocation(ANY_TIER, -1);
    }

    public static BlockStoreLocation anyDirInTier(String tierAlias) {
        return new BlockStoreLocation(tierAlias, -1);
    }

    public BlockStoreLocation(String tierAlias, int dirIndex) {
        this.mTierAlias = tierAlias;
        this.mDirIndex = dirIndex;
    }

    public String tierAlias() {
        return this.mTierAlias;
    }

    public int dir() {
        return this.mDirIndex;
    }

    public boolean belongsTo(BlockStoreLocation location) {
        boolean tierInRange = this.tierAlias().equals(location.tierAlias()) || location.tierAlias().equals(ANY_TIER);
        boolean dirInRange = this.dir() == location.dir() || location.dir() == -1;
        return tierInRange && dirInRange;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.mDirIndex == -1) {
            result.append("any dir");
        } else {
            result.append("dir ").append(this.mDirIndex);
        }
        if (this.mTierAlias == ANY_TIER) {
            result.append(", any tier");
        } else {
            result.append(", tierAlias ").append(this.mTierAlias);
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BlockStoreLocation)) {
            return false;
        }
        BlockStoreLocation that = (BlockStoreLocation)o;
        return this.mTierAlias.equals(that.mTierAlias) && this.mDirIndex == that.mDirIndex;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.mTierAlias, this.mDirIndex});
    }
}

