/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.collections.Pair;
import alluxio.worker.block.BlockMetadataManager;
import alluxio.worker.block.meta.StorageDir;
import alluxio.worker.block.meta.StorageTier;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class BlockStoreMeta {
    private final Map<String, Long> mCapacityBytesOnTiers = new HashMap<String, Long>();
    private final Map<String, Long> mUsedBytesOnTiers = new HashMap<String, Long>();
    private final Map<String, List<Long>> mBlockIdsOnTiers = new HashMap<String, List<Long>>();
    private final Map<Pair<String, String>, Long> mCapacityBytesOnDirs = new HashMap<Pair<String, String>, Long>();
    private final Map<Pair<String, String>, Long> mUsedBytesOnDirs = new HashMap<Pair<String, String>, Long>();

    public BlockStoreMeta(BlockMetadataManager manager) {
        Preconditions.checkNotNull((Object)manager);
        for (StorageTier tier : manager.getTiers()) {
            Long capacityBytes = this.mCapacityBytesOnTiers.get(tier.getTierAlias());
            Long usedBytes = this.mUsedBytesOnTiers.get(tier.getTierAlias());
            this.mCapacityBytesOnTiers.put(tier.getTierAlias(), (capacityBytes == null ? 0L : capacityBytes) + tier.getCapacityBytes());
            this.mUsedBytesOnTiers.put(tier.getTierAlias(), (usedBytes == null ? 0L : usedBytes) + (tier.getCapacityBytes() - tier.getAvailableBytes()));
            ArrayList<Long> blockIdsOnTier = new ArrayList<Long>();
            for (StorageDir dir : tier.getStorageDirs()) {
                blockIdsOnTier.addAll(dir.getBlockIds());
                Pair dirKey = new Pair((Object)tier.getTierAlias(), (Object)dir.getDirPath());
                this.mCapacityBytesOnDirs.put((Pair<String, String>)dirKey, dir.getCapacityBytes());
                this.mUsedBytesOnDirs.put((Pair<String, String>)dirKey, dir.getCapacityBytes() - dir.getAvailableBytes());
            }
            this.mBlockIdsOnTiers.put(tier.getTierAlias(), blockIdsOnTier);
        }
    }

    public Map<String, List<Long>> getBlockList() {
        return this.mBlockIdsOnTiers;
    }

    public long getCapacityBytes() {
        long capacityBytes = 0L;
        for (long capacityBytesOnTier : this.mCapacityBytesOnTiers.values()) {
            capacityBytes += capacityBytesOnTier;
        }
        return capacityBytes;
    }

    public Map<String, Long> getCapacityBytesOnTiers() {
        return this.mCapacityBytesOnTiers;
    }

    public Map<Pair<String, String>, Long> getCapacityBytesOnDirs() {
        return this.mCapacityBytesOnDirs;
    }

    public int getNumberOfBlocks() {
        int numberOfBlocks = 0;
        for (List<Long> blockIds : this.mBlockIdsOnTiers.values()) {
            numberOfBlocks += blockIds.size();
        }
        return numberOfBlocks;
    }

    public long getUsedBytes() {
        long usedBytes = 0L;
        for (long usedBytesOnTier : this.mUsedBytesOnTiers.values()) {
            usedBytes += usedBytesOnTier;
        }
        return usedBytes;
    }

    public Map<String, Long> getUsedBytesOnTiers() {
        return Collections.unmodifiableMap(this.mUsedBytesOnTiers);
    }

    public Map<Pair<String, String>, Long> getUsedBytesOnDirs() {
        return this.mUsedBytesOnDirs;
    }
}

