/*
 * Decompiled with CFR 0.152.
 */
package alluxio.worker.block;

import alluxio.StorageTierAssoc;
import alluxio.WorkerStorageTierAssoc;
import alluxio.exception.AlluxioException;
import alluxio.thrift.AlluxioTException;
import alluxio.thrift.BlockWorkerClientService;
import alluxio.thrift.LockBlockResult;
import alluxio.thrift.ThriftIOException;
import alluxio.worker.WorkerContext;
import alluxio.worker.block.BlockWorker;
import java.io.IOException;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public final class BlockWorkerClientServiceHandler
implements BlockWorkerClientService.Iface {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final BlockWorker mWorker;
    private final StorageTierAssoc mStorageTierAssoc;

    public BlockWorkerClientServiceHandler(BlockWorker worker) {
        this.mWorker = worker;
        this.mStorageTierAssoc = new WorkerStorageTierAssoc(WorkerContext.getConf());
    }

    public long getServiceVersion() {
        return 1L;
    }

    public void accessBlock(long blockId) throws AlluxioTException {
        try {
            this.mWorker.accessBlock(-5L, blockId);
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public boolean asyncCheckpoint(long fileId) throws AlluxioTException {
        return false;
    }

    public void cacheBlock(long sessionId, long blockId) throws AlluxioTException, ThriftIOException {
        try {
            this.mWorker.commitBlock(sessionId, blockId);
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public void cancelBlock(long sessionId, long blockId) throws AlluxioTException, ThriftIOException {
        try {
            this.mWorker.abortBlock(sessionId, blockId);
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
    }

    public LockBlockResult lockBlock(long blockId, long sessionId) throws AlluxioTException {
        try {
            long lockId = this.mWorker.lockBlock(sessionId, blockId);
            return new LockBlockResult(lockId, this.mWorker.readBlock(sessionId, blockId, lockId));
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public boolean promoteBlock(long blockId) throws AlluxioTException, ThriftIOException {
        try {
            this.mWorker.moveBlock(-3L, blockId, this.mStorageTierAssoc.getAlias(0));
            return true;
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
    }

    public String requestBlockLocation(long sessionId, long blockId, long initialBytes) throws AlluxioTException, ThriftIOException {
        try {
            return this.mWorker.createBlock(sessionId, blockId, this.mStorageTierAssoc.getAlias(0), initialBytes);
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
        catch (IOException e) {
            throw new ThriftIOException(e.getMessage());
        }
    }

    public boolean requestSpace(long sessionId, long blockId, long requestBytes) {
        try {
            this.mWorker.requestSpace(sessionId, blockId, requestBytes);
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to request {} bytes for block: {}", new Object[]{requestBytes, blockId, e});
            return false;
        }
    }

    public boolean unlockBlock(long blockId, long sessionId) throws AlluxioTException {
        try {
            this.mWorker.unlockBlock(sessionId, blockId);
            return true;
        }
        catch (AlluxioException e) {
            throw e.toAlluxioTException();
        }
    }

    public void sessionHeartbeat(long sessionId, List<Long> metrics) {
        this.mWorker.sessionHeartbeat(sessionId, metrics);
    }
}

